/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Route;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.FromType;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.util.CamelContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="route")
@XmlType(propOrder={"interceptors", "inputs", "outputs"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteType
extends ProcessorType
implements CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(RouteType.class);
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlElementRef
    private List<FromType> inputs = new ArrayList<FromType>();
    @XmlElementRef
    private List<ProcessorType> outputs = new ArrayList<ProcessorType>();
    @XmlTransient
    private CamelContext camelContext;

    public RouteType() {
    }

    public RouteType(String uri) {
        this.getInputs().add(new FromType(uri));
    }

    public RouteType(Endpoint endpoint) {
        this.getInputs().add(new FromType(endpoint));
    }

    public String toString() {
        return "Route[ " + this.inputs + " -> " + this.outputs + "]";
    }

    public void addRoutes(CamelContext context) throws Exception {
        ArrayList<Route> routes = new ArrayList<Route>();
        this.addRoutes(context, routes);
        context.addRoutes(routes);
    }

    public void addRoutes(CamelContext context, Collection<Route> routes) throws Exception {
        this.setCamelContext(context);
        for (FromType fromType : this.inputs) {
            this.addRoutes(routes, fromType);
        }
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            throw new IllegalArgumentException("No CamelContext has been injected!");
        }
        return CamelContextHelper.getMandatoryEndpoint(context, uri);
    }

    public RouteType from(String uri) {
        this.getInputs().add(new FromType(uri));
        return this;
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    public List<FromType> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<FromType> inputs) {
        this.inputs = inputs;
    }

    @Override
    public List<ProcessorType> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorType output : outputs) {
                this.configureChild(output);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void addRoutes(Collection<Route> routes, FromType fromType) throws Exception {
        RouteContext routeContext = new RouteContext(this, fromType, routes);
        Endpoint endpoint = routeContext.getEndpoint();
        for (ProcessorType output : this.outputs) {
            output.addRoutes(routeContext, routes);
        }
        routeContext.commit();
    }

    @Override
    protected void configureChild(ProcessorType output) {
        List<InterceptorType> list;
        if (this.isInheritErrorHandler()) {
            output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        }
        if ((list = output.getInterceptors()) == null) {
            LOG.warn("No interceptor collection: " + output);
        } else {
            list.addAll(this.getInterceptors());
        }
    }
}

