/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.InstrumentationAgent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.InstrumentationLifecycleStrategy;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class InstrumentationAgentImpl
implements InstrumentationAgent,
CamelContextAware {
    private MBeanServer server;
    private CamelContext context;
    private Set<ObjectName> mbeans = new HashSet<ObjectName>();
    MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler();

    public InstrumentationAgentImpl() {
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanInfo mbi = null;
            mbi = this.assembler.getMBeanInfo(obj, name.toString());
            RequiredModelMBean mbean = (RequiredModelMBean)this.server.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
            try {
                mbean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException itotex) {
                throw new JMException(itotex.getMessage());
            }
            this.registerMBeanWithServer(mbean, name, forceRegistration);
        }
    }

    public void unregister(ObjectName name) throws JMException {
    }

    public void start() {
        if (this.context == null) {
            return;
        }
        if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext dc = (DefaultCamelContext)this.context;
            InstrumentationLifecycleStrategy ls = new InstrumentationLifecycleStrategy(this);
            dc.setLifecycleStrategy(ls);
            ls.onContextCreate(this.context);
        }
    }

    public void stop() {
        Object[] mBeans;
        for (Object name : mBeans = this.mbeans.toArray()) {
            this.mbeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                // empty catch block
            }
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.server.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.server.unregisterMBean(name);
                instance = this.server.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.mbeans.add(name);
        }
    }
}

