/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmComponent<E extends Exchange>
extends SedaComponent<E> {
    protected static Map<String, BlockingQueue<Exchange>> queues = new HashMap<String, BlockingQueue<Exchange>>();

    @Override
    protected Endpoint<E> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        BlockingQueue<Exchange> blockingQueue = this.getBlockingQueue(uri);
        return new SedaEndpoint<Exchange>(uri, this, blockingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockingQueue<Exchange> getBlockingQueue(String uri) {
        Map<String, BlockingQueue<Exchange>> map = queues;
        synchronized (map) {
            BlockingQueue<Exchange> answer = queues.get(uri);
            if (answer == null) {
                answer = this.createQueue();
                queues.put(uri, answer);
            }
            return answer;
        }
    }
}

