/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanExchange;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerEndpoint
extends DefaultEndpoint<BeanExchange> {
    private final TimerComponent component;
    private final String timerName;
    private Date time;
    private long period = -1L;
    private long delay = -1L;
    private boolean fixedRate;
    private boolean daemon = true;

    public TimerEndpoint(String fullURI, TimerComponent component, String timerPartURI) throws URISyntaxException {
        super(fullURI, component);
        this.component = component;
        URI u = new URI(timerPartURI);
        Map options = URISupport.parseParamters(u);
        IntrospectionSupport.setProperties(this, options);
        this.timerName = u.getPath();
    }

    @Override
    public Producer<BeanExchange> createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    @Override
    public Consumer<BeanExchange> createConsumer(Processor processor) throws Exception {
        return new TimerConsumer(this, processor);
    }

    @Override
    public BeanExchange createExchange() {
        return new BeanExchange(this.getContext());
    }

    @Override
    public TimerComponent getComponent() {
        return this.component;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

