/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.RuntimeMailException;
import org.apache.camel.converter.ObjectConverter;

public class MailBinding {
    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) {
        try {
            this.appendHeadersFromCamel(mimeMessage, exchange, exchange.getIn());
            String destination = endpoint.getConfiguration().getDestination();
            if (destination != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, destination);
            }
            if (this.empty(mimeMessage.getFrom())) {
                String from = endpoint.getConfiguration().getFrom();
                mimeMessage.setFrom((Address)new InternetAddress(from));
            }
            mimeMessage.setText(exchange.getIn().getBody(String.class));
        }
        catch (Exception e) {
            throw new RuntimeMailException("Failed to populate body due to: " + e + ". Exchange: " + exchange, e);
        }
    }

    protected boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    public Object extractBodyFromMail(MailExchange exchange, javax.mail.Message message) {
        try {
            return message.getContent();
        }
        catch (Exception e) {
            throw new RuntimeMailException("Failed to extract body due to: " + e + ". Message: " + message, e);
        }
    }

    protected void appendHeadersFromCamel(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        Set<Map.Entry<String, Object>> entries = camelMessage.getHeaders().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String headerName = entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !this.shouldOutputHeader(camelMessage, headerName, headerValue)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectConverter.iterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, this.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, this.asString(exchange, headerValue));
        }
    }

    protected String asString(Exchange exchange, Object value) {
        return exchange.getContext().getTypeConverter().convertTo(String.class, value);
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        return true;
    }
}

