/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.impl.DefaultExchange;

public class JmsExchange
extends DefaultExchange {
    private JmsBinding binding;

    public JmsExchange(CamelContext context, JmsBinding binding) {
        super(context);
        this.binding = binding;
    }

    public JmsExchange(CamelContext context, JmsBinding binding, Message message) {
        this(context, binding);
        this.setIn(new JmsMessage(message));
    }

    public JmsMessage getIn() {
        return (JmsMessage)super.getIn();
    }

    public JmsMessage getOut() {
        return (JmsMessage)super.getOut();
    }

    public JmsMessage getOut(boolean lazyCreate) {
        return (JmsMessage)super.getOut(lazyCreate);
    }

    public JmsMessage getFault() {
        return (JmsMessage)super.getFault();
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public Exchange newInstance() {
        return new JmsExchange(this.getContext(), this.binding);
    }

    public Message getInMessage() {
        return this.getIn().getJmsMessage();
    }

    public Message getOutMessage() {
        return this.getOut().getJmsMessage();
    }

    public Message getFaultMessage() {
        return this.getOut().getJmsMessage();
    }

    protected JmsMessage createInMessage() {
        return new JmsMessage();
    }

    protected JmsMessage createOutMessage() {
        return new JmsMessage();
    }
}

