/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.cxf.BusException;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.local.LocalTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint<CxfExchange> {
    private CxfBinding binding;
    private final CxfComponent component;
    private final EndpointInfo endpointInfo;
    private boolean inOut = true;

    public CxfEndpoint(String uri, CxfComponent component, EndpointInfo endpointInfo) {
        super(uri, component);
        this.component = component;
        this.endpointInfo = endpointInfo;
    }

    @Override
    public Producer<CxfExchange> createProducer() throws Exception {
        return new CxfProducer(this, this.getLocalTransportFactory());
    }

    @Override
    public Consumer<CxfExchange> createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor, this.getLocalTransportFactory());
    }

    @Override
    public CxfExchange createExchange() {
        return new CxfExchange(this.getContext(), this.getBinding());
    }

    public CxfExchange createExchange(Message inMessage) {
        return new CxfExchange(this.getContext(), this.getBinding(), inMessage);
    }

    public CxfBinding getBinding() {
        if (this.binding == null) {
            this.binding = new CxfBinding();
        }
        return this.binding;
    }

    public void setBinding(CxfBinding binding) {
        this.binding = binding;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public LocalTransportFactory getLocalTransportFactory() throws BusException {
        return this.component.getLocalTransportFactory();
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }

    @Override
    public CxfComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

