/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spring.util.MethodInvocationStrategy;

public class DefaultMethodInvocationStrategy
implements MethodInvocationStrategy {
    private Map<Class, Expression> parameterTypeToExpressionMap = new ConcurrentHashMap<Class, Expression>();

    public synchronized Expression getDefaultParameterTypeExpression(Class parameterType) {
        return this.parameterTypeToExpressionMap.get(parameterType);
    }

    public synchronized void addParameterMapping(Class parameterType, Expression expression) {
        this.parameterTypeToExpressionMap.put(parameterType, expression);
    }

    public void loadDefaultRegistry() {
        this.addParameterMapping(Exchange.class, ExpressionBuilder.exchangeExpression());
        this.addParameterMapping(Message.class, ExpressionBuilder.inMessageExpression());
    }
}

