/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.component.pojo.PojoComponent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;

public class CamelServiceExporter
extends RemoteExporter
implements InitializingBean,
DisposableBean {
    CamelContext camelContext;
    PojoComponent pojoComponent;
    String serviceName;

    public void afterPropertiesSet() throws Exception {
        if (this.serviceName == null) {
            throw new IllegalArgumentException("The serviceName must be configured.");
        }
        if (this.pojoComponent == null) {
            if (this.camelContext == null) {
                throw new IllegalArgumentException("A pojoComponent or camelContext must be configured.");
            }
            this.pojoComponent = (PojoComponent)this.camelContext.getComponent("pojo");
            if (this.pojoComponent == null) {
                throw new IllegalArgumentException("The pojoComponent could not be found.");
            }
        }
        this.pojoComponent.addService(this.serviceName, this.getProxyForService());
    }

    public void destroy() throws Exception {
        if (this.serviceName != null) {
            this.pojoComponent.removeService(this.serviceName);
        }
    }

    public PojoComponent getPojoComponent() {
        return this.pojoComponent;
    }

    public void setPojoComponent(PojoComponent pojoComponent) {
        this.pojoComponent = pojoComponent;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

