/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageSupport
implements Message {
    private static final UuidGenerator defaultIdGenerator = new UuidGenerator();
    private Exchange exchange;
    private Object body;
    private String messageId = defaultIdGenerator.generateId();

    @Override
    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        Exchange e = this.getExchange();
        if (e != null) {
            return e.getContext().getTypeConverter().convertTo(type, this.getBody());
        }
        return (T)this.getBody();
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public <T> void setBody(Object body, Class<T> type) {
        T value;
        Exchange e = this.getExchange();
        if (e != null && (value = e.getContext().getTypeConverter().convertTo(type, body)) != null) {
            body = value;
        }
        this.setBody(body);
    }

    @Override
    public Message copy() {
        Message answer = this.newInstance();
        answer.setMessageId(this.getMessageId());
        answer.setBody(this.getBody());
        answer.getHeaders().putAll(this.getHeaders());
        return answer;
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }
}

