/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryPredicateSupport<E extends Exchange>
implements Predicate<E> {
    private final Expression<E> left;
    private final Expression<E> right;

    protected BinaryPredicateSupport(Expression<E> left, Expression<E> right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return this.left + " " + this.getOperationText() + " " + this.right;
    }

    @Override
    public boolean matches(E exchange) {
        Object leftValue = this.left.evaluate(exchange);
        Object rightValue = this.right.evaluate(exchange);
        return this.matches(exchange, leftValue, rightValue);
    }

    @Override
    public void assertMatches(String text, E exchange) {
        Object rightValue;
        Object leftValue = this.left.evaluate(exchange);
        if (!this.matches(exchange, leftValue, rightValue = this.right.evaluate(exchange))) {
            throw new AssertionError((Object)this.assertionFailureMessage(exchange, leftValue, rightValue));
        }
    }

    protected abstract boolean matches(E var1, Object var2, Object var3);

    protected abstract String getOperationText();

    protected String assertionFailureMessage(E exchange, Object leftValue, Object rightValue) {
        return this + " failed on " + exchange + " with left value <" + leftValue + "> right value <" + rightValue + ">";
    }
}

