/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import org.apache.camel.Processor;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailConsumer
extends ScheduledPollConsumer<MailExchange>
implements MessageCountListener {
    private static final transient Log log = LogFactory.getLog(MailConsumer.class);
    private final MailEndpoint endpoint;
    private final Folder folder;

    public MailConsumer(MailEndpoint endpoint, Processor processor, Folder folder) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.folder = folder;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.ensureFolderIsOpen();
        this.folder.addMessageCountListener((MessageCountListener)this);
    }

    @Override
    protected void doStop() throws Exception {
        this.folder.removeMessageCountListener((MessageCountListener)this);
        this.folder.close(true);
        super.doStop();
    }

    public void messagesAdded(MessageCountEvent event) {
        Message[] messages;
        for (Message message : messages = event.getMessages()) {
            try {
                if (message.getFlags().contains(Flags.Flag.DELETED)) continue;
                this.processMessage(message);
                this.flagMessageDeleted(message);
            }
            catch (MessagingException e) {
                this.handleException(e);
            }
        }
    }

    public void messagesRemoved(MessageCountEvent event) {
        Message[] messages;
        for (Message message : messages = event.getMessages()) {
            if (!log.isDebugEnabled()) continue;
            try {
                log.debug((Object)("Removing message: " + message.getSubject()));
            }
            catch (MessagingException e) {
                log.debug((Object)("Ignored: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    protected void poll() throws Exception {
        this.ensureFolderIsOpen();
        int count = this.folder.getMessageCount();
        if (count > 0) {
            Message[] messages = this.folder.getMessages();
            MessageCountEvent event = new MessageCountEvent(this.folder, 1, true, messages);
            this.messagesAdded(event);
        } else if (count == -1) {
            throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
        }
        this.folder.close(true);
    }

    protected void processMessage(Message message) {
        try {
            MailExchange exchange = this.endpoint.createExchange(message);
            this.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected void ensureFolderIsOpen() throws MessagingException {
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
    }

    protected void flagMessageDeleted(Message message) throws MessagingException {
        if (this.endpoint.getConfiguration().isDeleteProcessedMessages()) {
            message.setFlag(Flags.Flag.DELETED, true);
        } else {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }
}

