/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class JmsProducer
extends DefaultProducer {
    private static final transient Log log = LogFactory.getLog(JmsProducer.class);
    private final JmsEndpoint endpoint;
    private final JmsOperations template;

    public JmsProducer(JmsEndpoint endpoint, JmsOperations template) {
        super(endpoint);
        this.endpoint = endpoint;
        this.template = template;
    }

    public void process(final Exchange exchange) {
        this.template.send(this.endpoint.getDestination(), new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, session);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(JmsProducer.this.endpoint + " sending JMS message: " + message));
                }
                return message;
            }
        });
    }

    public JmsOperations getTemplate() {
        return this.template;
    }
}

