/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.MessagePropertyAccessException;
import org.apache.camel.component.jms.MessagePropertyNamesAccessException;
import org.apache.camel.impl.DefaultMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessage
extends DefaultMessage {
    private static final transient Log log = LogFactory.getLog(JmsMessage.class);
    private Message jmsMessage;

    public JmsMessage() {
    }

    public JmsMessage(Message jmsMessage) {
        this.setJmsMessage(jmsMessage);
    }

    @Override
    public String toString() {
        if (this.jmsMessage != null) {
            return "JmsMessage: " + this.jmsMessage;
        }
        return "JmsMessage: " + this.getBody();
    }

    public Message getJmsMessage() {
        return this.jmsMessage;
    }

    public void setJmsMessage(Message jmsMessage) {
        this.jmsMessage = jmsMessage;
        try {
            String id = this.getDestinationAsString(jmsMessage.getJMSDestination());
            id = id + this.getSanitizedString(jmsMessage.getJMSMessageID());
            this.setMessageId(id);
        }
        catch (JMSException e) {
            log.error((Object)("Failed to get message id from message " + jmsMessage), (Throwable)e);
        }
    }

    @Override
    public Object getHeader(String name) {
        Object answer = null;
        if (this.jmsMessage != null) {
            try {
                answer = this.jmsMessage.getObjectProperty(name);
            }
            catch (JMSException e) {
                throw new MessagePropertyAccessException(name, e);
            }
        }
        if (answer == null) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    @Override
    public JmsMessage newInstance() {
        return new JmsMessage();
    }

    @Override
    protected Object createBody() {
        if (this.jmsMessage != null && this.getExchange() instanceof JmsExchange) {
            JmsExchange exchange = (JmsExchange)this.getExchange();
            return exchange.getBinding().extractBodyFromJms(exchange, this.jmsMessage);
        }
        return null;
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null) {
            Enumeration names;
            try {
                names = this.jmsMessage.getPropertyNames();
            }
            catch (JMSException e) {
                throw new MessagePropertyNamesAccessException(e);
            }
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                try {
                    Object value = this.jmsMessage.getObjectProperty(name);
                    map.put(name, value);
                }
                catch (JMSException e) {
                    throw new MessagePropertyAccessException(name, e);
                }
            }
        }
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = "";
        result = destination instanceof Topic ? result + "topic" + File.separator + this.getSanitizedString(((Topic)destination).getTopicName()) : result + "queue" + File.separator + this.getSanitizedString(((Queue)destination).getQueueName());
        result = result + File.separator;
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

