/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbi;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jbi.JbiBinding;
import org.apache.camel.component.jbi.JbiException;
import org.apache.servicemix.jbi.resolver.URIResolver;

public class ToJbiProcessor
implements Processor {
    private JbiBinding binding;
    private ComponentContext componentContext;
    private String destinationUri;

    public ToJbiProcessor(JbiBinding binding, ComponentContext componentContext, String destinationUri) {
        this.binding = binding;
        this.componentContext = componentContext;
        this.destinationUri = destinationUri;
    }

    public void process(Exchange exchange) {
        try {
            DeliveryChannel deliveryChannel = this.componentContext.getDeliveryChannel();
            MessageExchangeFactory exchangeFactory = deliveryChannel.createExchangeFactory();
            MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, exchangeFactory);
            URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.componentContext, (String)this.destinationUri);
            deliveryChannel.sendSync(messageExchange);
        }
        catch (MessagingException e) {
            throw new JbiException(e);
        }
    }
}

