/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.util.EnumerationConverter;
import org.apache.bval.jsr.util.IOs;
import org.apache.bval.jsr.xml.AnnotationProxyBuilder;
import org.apache.bval.jsr.xml.AnnotationType;
import org.apache.bval.jsr.xml.BeanType;
import org.apache.bval.jsr.xml.ClassType;
import org.apache.bval.jsr.xml.ConstraintDefinitionType;
import org.apache.bval.jsr.xml.ConstraintMappingsType;
import org.apache.bval.jsr.xml.ConstraintType;
import org.apache.bval.jsr.xml.ConstructorType;
import org.apache.bval.jsr.xml.CrossParameterType;
import org.apache.bval.jsr.xml.ElementType;
import org.apache.bval.jsr.xml.FieldType;
import org.apache.bval.jsr.xml.GetterType;
import org.apache.bval.jsr.xml.GroupConversionType;
import org.apache.bval.jsr.xml.GroupSequenceType;
import org.apache.bval.jsr.xml.GroupsType;
import org.apache.bval.jsr.xml.MetaConstraint;
import org.apache.bval.jsr.xml.MethodType;
import org.apache.bval.jsr.xml.ParameterType;
import org.apache.bval.jsr.xml.PayloadType;
import org.apache.bval.jsr.xml.ReturnValueType;
import org.apache.bval.jsr.xml.ValidatedByType;
import org.apache.bval.jsr.xml.ValidationMappingParser$getGetter$$Ljava_lang_Class$Ljava_lang_String$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredField$$Ljava_lang_Class$Ljava_lang_String$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getPublicMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationParser;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class ValidationMappingParser {
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.1.xsd";
    private static final Set<ConstraintAnnotationAttributes> RESERVED_PARAMS;
    private final Set<Class<?>> processedClasses;
    private final ApacheValidatorFactory factory;

    public ValidationMappingParser(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.processedClasses = new HashSet();
    }

    public void processMappingConfig(Set<InputStream> xmlStreams) throws ValidationException {
        for (InputStream xmlStream : xmlStreams) {
            ConstraintMappingsType mapping = this.parseXmlMappings(xmlStream);
            String defaultPackage = mapping.getDefaultPackage();
            this.processConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage);
            for (BeanType bean : mapping.getBean()) {
                Class<?> beanClass = this.loadClass(bean.getClazz(), defaultPackage);
                if (!this.processedClasses.add(beanClass)) {
                    throw new ValidationException(beanClass.getName() + " has already be configured in xml.");
                }
                boolean ignoreAnnotations = bean.getIgnoreAnnotations() == null ? true : bean.getIgnoreAnnotations();
                this.factory.getAnnotationIgnores().setDefaultIgnoreAnnotation(beanClass, ignoreAnnotations);
                this.processClassLevel(bean.getClassType(), beanClass, defaultPackage);
                this.processConstructorLevel(bean.getConstructor(), beanClass, defaultPackage, ignoreAnnotations);
                this.processFieldLevel(bean.getField(), beanClass, defaultPackage, ignoreAnnotations);
                Collection<String> potentialMethodName = this.processPropertyLevel(bean.getGetter(), beanClass, defaultPackage, ignoreAnnotations);
                this.processMethodLevel(bean.getMethod(), beanClass, defaultPackage, ignoreAnnotations, potentialMethodName);
                this.processedClasses.add(beanClass);
            }
        }
    }

    private ConstraintMappingsType parseXmlMappings(InputStream in) {
        ConstraintMappingsType mappings;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConstraintMappingsType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(this.getSchema());
            StreamSource stream = new StreamSource(in);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ConstraintMappingsType.class);
            mappings = (ConstraintMappingsType)root.getValue();
        }
        catch (JAXBException e) {
            throw new ValidationException("Failed to parse XML deployment descriptor file.", (Throwable)e);
        }
        finally {
            IOs.closeQuietly(in);
            try {
                in.reset();
            }
            catch (IOException e) {}
        }
        return mappings;
    }

    private Schema getSchema() {
        return ValidationParser.getSchema(VALIDATION_MAPPING_XSD);
    }

    private void processClassLevel(ClassType classType, Class<?> beanClass, String defaultPackage) {
        Class<?>[] groupSequence;
        if (classType == null) {
            return;
        }
        if (classType.getIgnoreAnnotations() != null) {
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnClass(beanClass, classType.getIgnoreAnnotations());
        }
        if ((groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage)) != null) {
            this.factory.addDefaultSequence(beanClass, groupSequence);
        }
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint<?, ?> metaConstraint = this.createConstraint(constraint, beanClass, null, defaultPackage);
            this.factory.addMetaConstraint(beanClass, metaConstraint);
        }
    }

    private <A extends Annotation, T> MetaConstraint<?, ?> createConstraint(ConstraintType constraint, Class<T> beanClass, Member member, String defaultPackage) {
        Class<?> annotationClass = this.loadClass(constraint.getAnnotation(), defaultPackage);
        AnnotationProxyBuilder annoBuilder = new AnnotationProxyBuilder(annotationClass);
        if (constraint.getMessage() != null) {
            annoBuilder.setMessage(constraint.getMessage());
        }
        annoBuilder.setGroups(this.getGroups(constraint.getGroups(), defaultPackage));
        annoBuilder.setPayload(this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            this.checkValidName(name);
            Class<?> returnType = this.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType, defaultPackage);
            annoBuilder.putValue(name, elementValue);
        }
        return new MetaConstraint(beanClass, member, annoBuilder.createAnnotation());
    }

    private void checkValidName(String name) {
        for (ConstraintAnnotationAttributes attr : RESERVED_PARAMS) {
            if (!attr.getAttributeName().equals(name)) continue;
            throw new ValidationException(name + " is a reserved parameter name.");
        }
    }

    private <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$getPublicMethod(annotationClass, name, new Class[0]);
        if (m == null) {
            throw new ValidationException("Annotation of type " + annotationClass.getName() + " does not contain a parameter " + name + ".");
        }
        return m.getReturnType();
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getPublicMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getPublicMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$0(Class clazz, String string, Class[] classArray) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType, String defaultPackage) {
        this.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw new ValidationException("Attempt to specify an array where single value is expected.");
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType, defaultPackage);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Serializable s : elementType.getContent()) {
            values.add(this.getSingleValue(s, returnType.getComponentType(), defaultPackage));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private void removeEmptyContentElements(ElementType elementType) {
        ArrayList<Serializable> contentToDelete = new ArrayList<Serializable>();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType, String defaultPackage) {
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            return this.convertToResultType(returnType, value, defaultPackage);
        }
        if (serializable instanceof JAXBElement) {
            JAXBElement elem = (JAXBElement)serializable;
            if (String.class.equals((Object)elem.getDeclaredType())) {
                String value = (String)elem.getValue();
                return this.convertToResultType(returnType, value, defaultPackage);
            }
            if (AnnotationType.class.equals((Object)elem.getDeclaredType())) {
                AnnotationType annotationType = (AnnotationType)elem.getValue();
                try {
                    Class<?> annotationClass = returnType;
                    return this.createAnnotation(annotationType, annotationClass, defaultPackage);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Unexpected parameter value");
                }
            }
        }
        throw new ValidationException("Unexpected parameter value");
    }

    private Object convertToResultType(Class<?> returnType, String value, String defaultPackage) {
        if (returnType.equals(Class.class)) {
            value = this.toQualifiedClassName(value, defaultPackage);
        }
        if (Byte.class.equals(returnType) || Byte.TYPE.equals(returnType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.equals(returnType) || Short.TYPE.equals(returnType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.equals(returnType) || Integer.TYPE.equals(returnType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(returnType) || Long.TYPE.equals(returnType)) {
            return Long.parseLong(value);
        }
        if (Float.class.equals(returnType) || Float.TYPE.equals(returnType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(returnType) || Double.TYPE.equals(returnType)) {
            return Double.parseDouble(value);
        }
        if (Boolean.class.equals(returnType) || Boolean.TYPE.equals(returnType)) {
            return Boolean.parseBoolean(value);
        }
        if (Character.class.equals(returnType) || Character.TYPE.equals(returnType)) {
            if (value.length() > 1) {
                throw new IllegalArgumentException("a char has a length of 1");
            }
            return Character.valueOf(value.charAt(0));
        }
        Converter converter = ConvertUtils.lookup(returnType);
        if (converter == null && returnType.isEnum()) {
            converter = EnumerationConverter.getInstance();
        }
        if (converter == null) {
            return converter;
        }
        return converter.convert(returnType, (Object)value);
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType, String defaultPackage) {
        AnnotationProxyBuilder<Class<A>> metaAnnotation = new AnnotationProxyBuilder<Class<A>>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = this.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType, defaultPackage);
            metaAnnotation.putValue(name, elementValue);
        }
        return metaAnnotation.createAnnotation();
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        ArrayList groupList = new ArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(this.loadClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList payloadList = new ArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = this.loadClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw new ValidationException("Specified payload class " + payload.getName() + " does not implement javax.validation.Payload");
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private Class<?>[] createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        if (groupSequenceType != null) {
            Class[] groupSequence = new Class[groupSequenceType.getValue().size()];
            int i = 0;
            for (String groupName : groupSequenceType.getValue()) {
                Class<?> group = this.loadClass(groupName, defaultPackage);
                groupSequence[i++] = group;
            }
            return groupSequence;
        }
        return null;
    }

    private <A> void processMethodLevel(List<MethodType> methods, Class<A> beanClass, String defaultPackage, boolean parentIgnoreAnn, Collection<String> getters) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (MethodType methodType : methods) {
            CrossParameterType crossParameter;
            MetaConstraint<?, ?> constraint;
            String methodName = methodType.getName();
            if (methodNames.contains(methodName) || getters.contains(methodName)) {
                throw new ValidationException(methodName + " is defined more than once in mapping xml for bean " + beanClass.getName());
            }
            methodNames.add(methodName);
            Method method = ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(beanClass, methodName, this.toTypes(methodType.getParameter(), defaultPackage));
            if (method == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the method  " + methodName);
            }
            boolean ignoreMethodAnnotation = methodType.getIgnoreAnnotations() == null ? parentIgnoreAnn : methodType.getIgnoreAnnotations();
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(method, ignoreMethodAnnotation);
            boolean ignoreAnn = methodType.getIgnoreAnnotations() == null ? parentIgnoreAnn : methodType.getIgnoreAnnotations();
            int i = 0;
            for (ParameterType p : methodType.getParameter()) {
                for (ConstraintType constraintType : p.getConstraint()) {
                    constraint = this.createConstraint(constraintType, beanClass, method, defaultPackage);
                    constraint.setIndex(i);
                    this.factory.addMetaConstraint(beanClass, constraint);
                }
                if (p.getValid() != null) {
                    MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation> constraint2 = new MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation>(beanClass, method, AnnotationProxyBuilder.ValidAnnotation.INSTANCE);
                    constraint2.setIndex(i);
                    this.factory.addMetaConstraint(beanClass, constraint2);
                }
                if (p.getConvertGroup() != null) {
                    for (GroupConversionType groupConversion : p.getConvertGroup()) {
                        Class<?> from = this.loadClass(groupConversion.getFrom(), defaultPackage);
                        Class<?> to = this.loadClass(groupConversion.getTo(), defaultPackage);
                        MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint3 = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, method, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                        constraint3.setIndex(i);
                        this.factory.addMetaConstraint(beanClass, constraint3);
                    }
                }
                boolean ignoreParametersAnnotation = p.getIgnoreAnnotations() == null ? ignoreMethodAnnotation : p.getIgnoreAnnotations();
                this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnParameter(method, i, ignoreParametersAnnotation);
                ++i;
            }
            ReturnValueType returnValue = methodType.getReturnValue();
            if (returnValue != null) {
                for (ConstraintType constraintType : returnValue.getConstraint()) {
                    MetaConstraint<?, ?> constraint4 = this.createConstraint(constraintType, beanClass, method, defaultPackage);
                    this.factory.addMetaConstraint(beanClass, constraint4);
                }
                if (returnValue.getValid() != null) {
                    MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation> constraint5 = new MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation>(beanClass, method, AnnotationProxyBuilder.ValidAnnotation.INSTANCE);
                    this.factory.addMetaConstraint(beanClass, constraint5);
                }
                if (returnValue.getConvertGroup() != null) {
                    for (GroupConversionType groupConversion : returnValue.getConvertGroup()) {
                        Class<?> from = this.loadClass(groupConversion.getFrom(), defaultPackage);
                        Class<?> to = this.loadClass(groupConversion.getTo(), defaultPackage);
                        MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint6 = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, method, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                        this.factory.addMetaConstraint(beanClass, constraint6);
                    }
                }
                this.factory.getAnnotationIgnores().setIgnoreAnnotationOnReturn(method, returnValue.getIgnoreAnnotations() == null ? ignoreAnn : returnValue.getIgnoreAnnotations());
            }
            if ((crossParameter = methodType.getCrossParameter()) == null) continue;
            for (ConstraintType constraintType : crossParameter.getConstraint()) {
                constraint = this.createConstraint(constraintType, beanClass, method, defaultPackage);
                this.factory.addMetaConstraint(beanClass, constraint);
            }
            this.factory.getAnnotationIgnores().setIgnoreAnnotationOnCrossParameter(method, crossParameter.getIgnoreAnnotations() != null ? crossParameter.getIgnoreAnnotations() : ignoreAnn);
        }
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$1(Class clazz, String string, Class[] classArray) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <A> void processConstructorLevel(List<ConstructorType> constructors, Class<A> beanClass, String defaultPackage, boolean parentIgnore) {
        for (ConstructorType constructorType : constructors) {
            CrossParameterType crossParameter;
            MetaConstraint<?, ?> constraint;
            Constructor<A> constructor = ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(beanClass, this.toTypes(constructorType.getParameter(), defaultPackage));
            if (constructor == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the constructor  " + constructorType);
            }
            boolean ignoreMethodAnnotation = constructorType.getIgnoreAnnotations() == null ? parentIgnore : constructorType.getIgnoreAnnotations();
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(constructor, ignoreMethodAnnotation);
            boolean ignoreAnn = constructorType.getIgnoreAnnotations() == null ? parentIgnore : constructorType.getIgnoreAnnotations();
            int i = 0;
            for (ParameterType p : constructorType.getParameter()) {
                boolean ignoreParametersAnnotation;
                for (ConstraintType constraintType : p.getConstraint()) {
                    constraint = this.createConstraint(constraintType, beanClass, constructor, defaultPackage);
                    constraint.setIndex(i);
                    this.factory.addMetaConstraint(beanClass, constraint);
                }
                if (p.getValid() != null) {
                    MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation> constraint2 = new MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation>(beanClass, constructor, AnnotationProxyBuilder.ValidAnnotation.INSTANCE);
                    constraint2.setIndex(i);
                    this.factory.addMetaConstraint(beanClass, constraint2);
                }
                if (p.getConvertGroup() != null) {
                    for (GroupConversionType groupConversion : p.getConvertGroup()) {
                        Class<?> from = this.loadClass(groupConversion.getFrom(), defaultPackage);
                        Class<?> to = this.loadClass(groupConversion.getTo(), defaultPackage);
                        MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint3 = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, constructor, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                        constraint3.setIndex(i);
                        this.factory.addMetaConstraint(beanClass, constraint3);
                    }
                }
                boolean bl = ignoreParametersAnnotation = p.getIgnoreAnnotations() == null ? ignoreMethodAnnotation : p.getIgnoreAnnotations();
                if (ignoreParametersAnnotation || !ignoreMethodAnnotation || p.getIgnoreAnnotations() == null) {
                    // empty if block
                }
                this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnParameter(constructor, i, p.getIgnoreAnnotations() != null ? p.getIgnoreAnnotations() : ignoreAnn);
                ++i;
            }
            ReturnValueType returnValue = constructorType.getReturnValue();
            if (returnValue != null) {
                for (ConstraintType constraintType : returnValue.getConstraint()) {
                    MetaConstraint<?, ?> constraint4 = this.createConstraint(constraintType, beanClass, constructor, defaultPackage);
                    constraint4.setIndex(-1);
                    this.factory.addMetaConstraint(beanClass, constraint4);
                }
                if (returnValue.getValid() != null) {
                    MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation> constraint5 = new MetaConstraint<A, AnnotationProxyBuilder.ValidAnnotation>(beanClass, constructor, AnnotationProxyBuilder.ValidAnnotation.INSTANCE);
                    constraint5.setIndex(-1);
                    this.factory.addMetaConstraint(beanClass, constraint5);
                }
                if (returnValue.getConvertGroup() != null) {
                    for (GroupConversionType groupConversion : returnValue.getConvertGroup()) {
                        Class<?> from = this.loadClass(groupConversion.getFrom(), defaultPackage);
                        Class<?> to = this.loadClass(groupConversion.getTo(), defaultPackage);
                        MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint6 = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, constructor, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                        constraint6.setIndex(-1);
                        this.factory.addMetaConstraint(beanClass, constraint6);
                    }
                }
                this.factory.getAnnotationIgnores().setIgnoreAnnotationOnReturn(constructor, returnValue.getIgnoreAnnotations() != null ? returnValue.getIgnoreAnnotations() : ignoreAnn);
            }
            if ((crossParameter = constructorType.getCrossParameter()) == null) continue;
            for (ConstraintType constraintType : crossParameter.getConstraint()) {
                constraint = this.createConstraint(constraintType, beanClass, constructor, defaultPackage);
                this.factory.addMetaConstraint(beanClass, constraint);
            }
            this.factory.getAnnotationIgnores().setIgnoreAnnotationOnCrossParameter(constructor, crossParameter.getIgnoreAnnotations() != null ? crossParameter.getIgnoreAnnotations() : ignoreAnn);
        }
    }

    @Privileged
    private static /* synthetic */ <T> Constructor<T> org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(Class<T> clazz, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(clazz, classArray);
        }
        return (Constructor)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor$$Ljava_lang_Class$arrayOfLjava_lang_Class$_ACTION(clazz, classArray));
    }

    static /* synthetic */ Constructor __privileged_access$2(Class clazz, Class[] classArray) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(clazz, classArray);
    }

    private static /* synthetic */ <T> Constructor<T> __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredConstructor(Class<T> clazz, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Class<?>[] toTypes(List<ParameterType> parameter, String defaultPck) {
        if (parameter == null) {
            return null;
        }
        Class[] types = new Class[parameter.size()];
        int i = 0;
        for (ParameterType type : parameter) {
            types[i++] = this.loadClass(type.getType(), defaultPck);
        }
        return types;
    }

    private <A> void processFieldLevel(List<FieldType> fields, Class<A> beanClass, String defaultPackage, boolean ignoreAnnotations) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType fieldType : fields) {
            String fieldName = fieldType.getName();
            if (fieldNames.contains(fieldName)) {
                throw new ValidationException(fieldName + " is defined more than once in mapping xml for bean " + beanClass.getName());
            }
            fieldNames.add(fieldName);
            Field field = ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$getDeclaredField(beanClass, fieldName);
            if (field == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the fieldType  " + fieldName);
            }
            boolean ignoreFieldAnnotation = fieldType.getIgnoreAnnotations() == null ? ignoreAnnotations : fieldType.getIgnoreAnnotations();
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(field, ignoreFieldAnnotation);
            if (fieldType.getValid() != null) {
                this.factory.addValid(beanClass, new FieldAccess(field));
            }
            for (GroupConversionType conversion : fieldType.getConvertGroup()) {
                Class<?> from = this.loadClass(conversion.getFrom(), defaultPackage);
                Class<?> to = this.loadClass(conversion.getTo(), defaultPackage);
                MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, field, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                this.factory.addMetaConstraint(beanClass, constraint);
            }
            for (ConstraintType constraintType : fieldType.getConstraint()) {
                MetaConstraint<?, ?> constraint = this.createConstraint(constraintType, beanClass, field, defaultPackage);
                this.factory.addMetaConstraint(beanClass, constraint);
            }
        }
    }

    @Privileged
    private static /* synthetic */ Field org_apache_bval_util_reflection_Reflection$$getDeclaredField(Class<?> clazz, String string) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(clazz, string);
        }
        return (Field)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getDeclaredField$$Ljava_lang_Class$Ljava_lang_String$_ACTION(clazz, string));
    }

    static /* synthetic */ Field __privileged_access$3(Class clazz, String string) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(clazz, string);
    }

    private static /* synthetic */ Field __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private <A> Collection<String> processPropertyLevel(List<GetterType> getters, Class<A> beanClass, String defaultPackage, boolean ignoreAnnotatino) {
        ArrayList<String> getterNames = new ArrayList<String>();
        for (GetterType getterType : getters) {
            String getterName = getterType.getName();
            String methodName = "get" + StringUtils.capitalize((String)getterType.getName());
            if (getterNames.contains(methodName)) {
                throw new ValidationException(getterName + " is defined more than once in mapping xml for bean " + beanClass.getName());
            }
            getterNames.add(methodName);
            Method method = ValidationMappingParser.getGetter(beanClass, getterName);
            if (method == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the property  " + getterName);
            }
            boolean ignoreGetterAnnotation = getterType.getIgnoreAnnotations() == null ? ignoreAnnotatino : getterType.getIgnoreAnnotations();
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(method, ignoreGetterAnnotation);
            if (getterType.getValid() != null) {
                this.factory.addValid(beanClass, new MethodAccess(getterName, method));
            }
            for (GroupConversionType conversion : getterType.getConvertGroup()) {
                Class<?> from = this.loadClass(conversion.getFrom(), defaultPackage);
                Class<?> to = this.loadClass(conversion.getTo(), defaultPackage);
                MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation> constraint = new MetaConstraint<A, AnnotationProxyBuilder.ConvertGroupAnnotation>(beanClass, method, new AnnotationProxyBuilder.ConvertGroupAnnotation(from, to));
                this.factory.addMetaConstraint(beanClass, constraint);
            }
            for (ConstraintType constraintType : getterType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createConstraint(constraintType, beanClass, method, defaultPackage);
                this.factory.addMetaConstraint(beanClass, metaConstraint);
            }
        }
        return getterNames;
    }

    private void processConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.loadClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw new ValidationException(annotationClassName + " is not an annotation");
            }
            Class<?> annotationClass = clazz;
            ValidatedByType validatedByType = constraintDefinition.getValidatedBy();
            ArrayList classes = new ArrayList();
            if (validatedByType.getIncludeExistingValidators() != null && validatedByType.getIncludeExistingValidators().booleanValue()) {
                classes.addAll(this.findConstraintValidatorClasses(annotationClass));
            }
            for (String validatorClassName : validatedByType.getValue()) {
                Class<?> validatorClass = this.loadClass(validatorClassName);
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                    throw new ValidationException(validatorClass + " is not a constraint validator class");
                }
                if (classes.contains(validatorClass)) continue;
                classes.add(validatorClass);
            }
            if (this.factory.getConstraintsCache().containsConstraintValidator(annotationClass)) {
                throw new ValidationException("Constraint validator for " + annotationClass.getName() + " already configured.");
            }
            this.factory.getConstraintsCache().putConstraintValidator(annotationClass, classes.toArray(new Class[classes.size()]));
        }
    }

    private List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> findConstraintValidatorClasses(Class<? extends Annotation> annotationType) {
        ArrayList classes = new ArrayList();
        Class<ConstraintValidator<? extends Annotation, ?>>[] validator = this.factory.getDefaultConstraints().getValidatorClasses(annotationType);
        if (validator == null) {
            Class[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            classes.addAll(Arrays.asList(validatedBy));
        } else {
            Collections.addAll(classes, validator);
        }
        return classes;
    }

    private Class<?> loadClass(String className, String defaultPackage) {
        return this.loadClass(this.toQualifiedClassName(className, defaultPackage));
    }

    private String toQualifiedClassName(String className, String defaultPackage) {
        if (!this.isQualifiedClass(className)) {
            className = className.startsWith("[L") && className.endsWith(";") ? "[L" + defaultPackage + "." + className.substring(2) : defaultPackage + "." + className;
        }
        return className;
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.contains(".");
    }

    @Privileged
    private static Method getGetter(Class<?> clazz, String string) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_getGetter(clazz, string);
        }
        return (Method)AccessController.doPrivileged(new ValidationMappingParser$getGetter$$Ljava_lang_Class$Ljava_lang_String$_ACTION(clazz, string));
    }

    static /* synthetic */ Method __privileged_access$4(Class clazz, String string) {
        return ValidationMappingParser.__privileged_getGetter(clazz, string);
    }

    private static Method __privileged_getGetter(Class<?> clazz, String propertyName) {
        try {
            String p = StringUtils.capitalize((String)propertyName);
            try {
                return clazz.getMethod("get" + p, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return clazz.getMethod("is" + p, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$getClassLoader(ValidationMappingParser.class);
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ValidationException("Unable to load class: " + className, (Throwable)ex);
        }
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$5(Class clazz) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    private static void __privileged_clinit0() {
        RESERVED_PARAMS = Collections.unmodifiableSet(EnumSet.of(ConstraintAnnotationAttributes.GROUPS, ConstraintAnnotationAttributes.MESSAGE, ConstraintAnnotationAttributes.PAYLOAD, ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO));
    }

    static {
        ValidationMappingParser.__privileged_clinit0();
    }
}

