/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.commons.lang3.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheValidationProvider
implements ValidationProvider<ApacheValidatorConfiguration> {
    public boolean isSuitable(Class<? extends Configuration<?>> builderClass) {
        return ApacheValidatorConfiguration.class == builderClass;
    }

    public ApacheValidatorConfiguration createSpecializedConfiguration(BootstrapState state) {
        return new ConfigurationImpl(state, this);
    }

    public Configuration<?> createGenericConfiguration(BootstrapState state) {
        return new ConfigurationImpl(state, null);
    }

    public ValidatorFactory buildValidatorFactory(final ConfigurationState configuration) {
        Class validatorFactoryClass;
        try {
            String validatorFactoryClassname = (String)configuration.getProperties().get("apache.bval.validator-factory-classname");
            if (validatorFactoryClassname == null) {
                validatorFactoryClass = ApacheValidatorFactory.class;
            } else {
                validatorFactoryClass = ClassUtils.getClass((String)validatorFactoryClassname);
                validatorFactoryClass.asSubclass(ValidatorFactory.class);
            }
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValidationException("error building ValidatorFactory", (Throwable)ex);
        }
        return System.getSecurityManager() == null ? ApacheValidationProvider.instantiateValidatorFactory(validatorFactoryClass, configuration) : AccessController.doPrivileged(new PrivilegedAction<ValidatorFactory>(){

            @Override
            public ValidatorFactory run() {
                return ApacheValidationProvider.instantiateValidatorFactory(validatorFactoryClass, configuration);
            }
        });
    }

    private static ValidatorFactory instantiateValidatorFactory(Class<? extends ValidatorFactory> validatorFactoryClass, ConfigurationState configuration) {
        try {
            return validatorFactoryClass.getConstructor(ConfigurationState.class).newInstance(configuration);
        }
        catch (Exception ex) {
            throw new ValidationException("Cannot instantiate : " + validatorFactoryClass, (Throwable)ex);
        }
    }
}

