/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.Scope;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.jsr303.groups.GroupsComputer;
import org.apache.bval.model.MetaBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConstraintFinderImpl
implements ElementDescriptor.ConstraintFinder {
    private final MetaBean metaBean;
    private final Set<Scope> findInScopes;
    private Set<ConstraintValidation<?>> constraintDescriptors;

    ConstraintFinderImpl(MetaBean metaBean, Set<ConstraintValidation<?>> constraintDescriptors) {
        this.metaBean = metaBean;
        this.constraintDescriptors = constraintDescriptors;
        this.findInScopes = new HashSet<Scope>(Arrays.asList(Scope.values()));
    }

    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        HashSet matchingDescriptors = new HashSet(this.constraintDescriptors.size());
        Groups groupChain = new GroupsComputer().computeGroups(groups);
        for (Group group : groupChain.getGroups()) {
            if (group.isDefault()) {
                List expandedDefaultGroup = (List)this.metaBean.getFeature("GroupSequence");
                for (Group defaultGroupMember : expandedDefaultGroup) {
                    for (ConstraintValidation<?> descriptor : this.constraintDescriptors) {
                        if (!this.isInScope(descriptor) || !this.isInGroup(descriptor, defaultGroupMember)) continue;
                        matchingDescriptors.add(descriptor);
                    }
                }
                continue;
            }
            for (ConstraintValidation<?> descriptor : this.constraintDescriptors) {
                if (!this.isInScope(descriptor) || !this.isInGroup(descriptor, group)) continue;
                matchingDescriptors.add(descriptor);
            }
        }
        return this.thisWith(matchingDescriptors);
    }

    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        if (scope.equals((Object)Scope.LOCAL_ELEMENT)) {
            this.findInScopes.remove(Scope.HIERARCHY);
            Iterator<ConstraintValidation<?>> it = this.constraintDescriptors.iterator();
            while (it.hasNext()) {
                ConstraintValidation<?> cv = it.next();
                if (cv.getOwner() == this.metaBean.getBeanClass()) continue;
                it.remove();
            }
        }
        return this;
    }

    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... elementTypes) {
        HashSet matchingDescriptors = new HashSet(this.constraintDescriptors.size());
        for (ElementType each : elementTypes) {
            for (ConstraintValidation<?> descriptor : this.constraintDescriptors) {
                if (!this.isInScope(descriptor) || !this.isAtElement(descriptor, each)) continue;
                matchingDescriptors.add(descriptor);
            }
        }
        return this.thisWith(matchingDescriptors);
    }

    private boolean isAtElement(ConstraintValidation<?> descriptor, ElementType each) {
        return descriptor.getAccess().getElementType() == each;
    }

    private boolean isInScope(ConstraintValidation<?> descriptor) {
        if (this.findInScopes.size() == Scope.values().length) {
            return true;
        }
        if (this.metaBean != null) {
            Class<?> owner = descriptor.getOwner();
            for (Scope scope : this.findInScopes) {
                switch (scope) {
                    case LOCAL_ELEMENT: {
                        if (!owner.equals(this.metaBean.getBeanClass())) break;
                        return true;
                    }
                    case HIERARCHY: {
                        if (owner.equals(this.metaBean.getBeanClass())) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isInGroup(ConstraintValidation<?> descriptor, Group group) {
        return descriptor.getGroups().contains(group.getGroup());
    }

    private ElementDescriptor.ConstraintFinder thisWith(Set<ConstraintValidation<?>> matchingDescriptors) {
        this.constraintDescriptors = matchingDescriptors;
        return this;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    public boolean hasConstraints() {
        return !this.constraintDescriptors.isEmpty();
    }
}

