/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.beans.Introspector;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.PrivilegedActions;

public class MethodAccess
extends AccessStrategy {
    private final Method method;
    private final String propertyName;

    public Type getJavaType() {
        return this.method.getGenericReturnType();
    }

    public MethodAccess(Method method) {
        this(MethodAccess.getPropertyName(method), method);
    }

    public MethodAccess(String propertyName, Method method) {
        this.method = method;
        this.propertyName = propertyName;
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public static String getPropertyName(Method member) {
        String name = null;
        String methodName = member.getName();
        if (methodName.startsWith("is")) {
            name = Introspector.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("get")) {
            name = Introspector.decapitalize(methodName.substring(3));
        }
        return name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object get(final Object instance) {
        return PrivilegedActions.run(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return MethodAccess.this.method.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodAccess that = (MethodAccess)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

