/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import org.apache.bval.model.Features;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaProperty;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBean
extends FeaturesCapable
implements Cloneable,
Features.Bean {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private Class<?> beanClass;
    private MetaProperty[] properties = new MetaProperty[0];

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public MetaProperty[] getProperties() {
        return this.properties;
    }

    public void setProperties(MetaProperty[] properties) {
        this.properties = properties;
    }

    public MetaProperty getProperty(String name) {
        for (MetaProperty p : this.properties) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public boolean hasRelationships() {
        for (MetaProperty p : this.properties) {
            if (!p.isRelationship()) continue;
            return true;
        }
        return false;
    }

    public boolean hasProperties() {
        return this.properties.length > 0;
    }

    public void putProperty(String name, MetaProperty property) {
        MetaProperty oldProperty = this.getProperty(name);
        if (property != null) {
            property.setParentMetaBean(this);
        }
        if (oldProperty == null) {
            if (this.properties.length == 0) {
                this.properties = new MetaProperty[1];
            } else {
                MetaProperty[] newproperties = new MetaProperty[this.properties.length + 1];
                System.arraycopy(this.properties, 0, newproperties, 0, this.properties.length);
                this.properties = newproperties;
            }
            this.properties[this.properties.length - 1] = property;
        } else {
            int idx = ArrayUtils.indexOf((Object[])this.properties, (Object)oldProperty);
            this.properties[idx] = property;
        }
    }

    public String toString() {
        return "MetaBean{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", beanClass=" + this.beanClass + '}';
    }

    @Override
    protected <T extends FeaturesCapable> void copyInto(T target) {
        super.copyInto(target);
        MetaBean copy = (MetaBean)target;
        if (this.properties != null) {
            copy.properties = (MetaProperty[])this.properties.clone();
            for (int i = copy.properties.length - 1; i >= 0; --i) {
                copy.properties[i] = (MetaProperty)copy.properties[i].copy();
            }
        }
    }

    public MetaBean resolveMetaBean(Object bean) {
        return bean == null || bean == this.beanClass || this.beanClass.isInstance(bean) ? this : null;
    }
}

