/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr303.ConstraintViolationImpl;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintValidationListener<T>
implements ValidationListener {
    private final Set<ConstraintViolation<T>> constaintViolations = new HashSet<ConstraintViolation<T>>();
    private final T rootBean;
    private final Class<T> rootBeanType;

    public ConstraintValidationListener(T aRootBean, Class<T> rootBeanType) {
        this.rootBean = aRootBean;
        this.rootBeanType = rootBeanType;
    }

    public void addError(String reason, ValidationContext context) {
        this.addError(reason, null, context);
    }

    public void addError(ValidationListener.Error error, ValidationContext context) {
        if (error.getOwner() instanceof Path) {
            this.addError(error.getReason(), (Path)error.getOwner(), context);
        } else {
            this.addError(error.getReason(), null, context);
        }
    }

    private void addError(String messageTemplate, Path propPath, ValidationContext context) {
        ConstraintDescriptor descriptor;
        String message;
        Object value;
        if (context instanceof GroupValidationContext) {
            GroupValidationContext gcontext = (GroupValidationContext)context;
            value = gcontext.getValidatedValue();
            message = gcontext instanceof MessageInterpolator.Context ? gcontext.getMessageResolver().interpolate(messageTemplate, (MessageInterpolator.Context)gcontext) : gcontext.getMessageResolver().interpolate(messageTemplate, null);
            descriptor = gcontext.getConstraintValidation().asSerializableDescriptor();
            if (propPath == null) {
                propPath = gcontext.getPropertyPath();
            }
        } else {
            value = context.getMetaProperty() == null ? context.getBean() : context.getPropertyValue();
            message = messageTemplate;
            if (propPath == null) {
                propPath = PathImpl.createPathFromString(context.getPropertyName());
            }
            descriptor = null;
        }
        ElementType elementType = context.getAccess() != null ? context.getAccess().getElementType() : null;
        ConstraintViolationImpl<T> ic = new ConstraintViolationImpl<T>(messageTemplate, message, this.rootBean, context.getBean(), propPath, value, descriptor, this.rootBeanType, elementType);
        this.constaintViolations.add(ic);
    }

    public Set<ConstraintViolation<T>> getConstaintViolations() {
        return this.constaintViolations;
    }

    public boolean isEmpty() {
        return this.constaintViolations.isEmpty();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanType() {
        return this.rootBeanType;
    }

    public int violationsSize() {
        return this.constaintViolations.size();
    }
}

