/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.jsr303.ConstraintDescriptorImpl;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.ConstraintValidatorContextImpl;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidation<T extends Annotation>
implements Validation,
ConstraintDescriptor<T> {
    private static final String ANNOTATION_MESSAGE = "message";
    private final ConstraintValidator validator;
    private T annotation;
    private final AccessStrategy access;
    private final boolean reportFromComposite;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Set<ConstraintValidation<?>> composedConstraints;
    private final Class owner;
    private Set<Class<?>> groups;
    private Set<Class<? extends Payload>> payload;
    private Class<? extends ConstraintValidator<T, ?>>[] validatorClasses;

    public ConstraintValidation(Class<? extends ConstraintValidator<T, ?>>[] validatorClasses, ConstraintValidator validator, T annotation, Class owner, AccessStrategy access, boolean reportFromComposite) {
        this.validatorClasses = validatorClasses;
        this.validator = validator;
        this.annotation = annotation;
        this.owner = owner;
        this.access = access;
        this.reportFromComposite = reportFromComposite;
    }

    public ConstraintDescriptor<T> asSerializableDescriptor() {
        return new ConstraintDescriptorImpl(this);
    }

    void setGroups(Set<Class<?>> groups) {
        this.groups = groups;
        this.attributes.put("groups", groups.toArray(new Class[groups.size()]));
    }

    void setPayload(Set<Class<? extends Payload>> payload) {
        this.payload = payload;
        this.attributes.put("payload", payload.toArray(new Class[payload.size()]));
    }

    public boolean isReportAsSingleViolation() {
        return this.reportFromComposite;
    }

    public void addComposed(ConstraintValidation aConstraintValidation) {
        if (this.composedConstraints == null) {
            this.composedConstraints = new HashSet();
        }
        this.composedConstraints.add(aConstraintValidation);
    }

    public void validate(ValidationContext context) {
        this.validate((GroupValidationContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(GroupValidationContext context) {
        context.setConstraintValidation(this);
        if (!this.isMemberOf(context.getCurrentGroup().getGroup())) {
            return;
        }
        if (context.getCurrentOwner() != null && this.owner != context.getCurrentOwner()) {
            return;
        }
        if (this.validator != null && !context.collectValidated(this.validator)) {
            return;
        }
        if (context.getMetaProperty() != null && !this.isReachable(context)) {
            return;
        }
        if (this.isReportAsSingleViolation()) {
            BeanValidationContext gctx = (BeanValidationContext)((Object)context);
            ConstraintValidationListener oldListener = (ConstraintValidationListener)gctx.getListener();
            ConstraintValidationListener listener = new ConstraintValidationListener(oldListener.getRootBean(), oldListener.getRootBeanType());
            gctx.setListener(listener);
            try {
                for (ConstraintValidation<?> composed : this.getComposingValidations()) {
                    composed.validate(context);
                }
            }
            finally {
                gctx.setListener(oldListener);
            }
            context.setConstraintValidation(this);
            if (!listener.getConstaintViolations().isEmpty()) {
                ConstraintValidatorContextImpl jsrContext = new ConstraintValidatorContextImpl(context, this);
                this.addErrors(context, jsrContext);
                return;
            }
        } else {
            for (ConstraintValidation<?> composed : this.getComposingValidations()) {
                composed.validate(context);
            }
            context.setConstraintValidation(this);
        }
        if (this.validator != null) {
            ConstraintValidatorContextImpl jsrContext = new ConstraintValidatorContextImpl(context, this);
            if (!this.validator.isValid(context.getValidatedValue(), (ConstraintValidatorContext)jsrContext)) {
                this.addErrors(context, jsrContext);
            }
        }
    }

    public void initialize() {
        if (null != this.validator) {
            try {
                this.validator.initialize(this.annotation);
            }
            catch (RuntimeException e) {
                throw new ConstraintDefinitionException("Incorrect validator [" + this.validator.getClass().getCanonicalName() + "] for annotation " + this.annotation.annotationType().getCanonicalName(), (Throwable)e);
            }
        }
    }

    private boolean isReachable(GroupValidationContext context) {
        PathImpl path = context.getPropertyPath();
        NodeImpl node = path.getLeafNode();
        PathImpl beanPath = path.getPathWithoutLeafNode();
        if (beanPath == null) {
            beanPath = PathImpl.create(null);
        }
        try {
            if (!context.getTraversableResolver().isReachable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, this.access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error in TraversableResolver.isReachable() for " + context.getBean(), (Throwable)e);
        }
        return true;
    }

    private void addErrors(GroupValidationContext context, ConstraintValidatorContextImpl jsrContext) {
        for (ValidationListener.Error each : jsrContext.getErrorMessages()) {
            context.getListener().addError(each, context);
        }
    }

    public String toString() {
        return "ConstraintValidation{" + this.validator + '}';
    }

    public String getMessageTemplate() {
        return (String)this.attributes.get(ANNOTATION_MESSAGE);
    }

    public ConstraintValidator getValidator() {
        return this.validator;
    }

    protected boolean isMemberOf(Class<?> reqGroup) {
        return this.groups.contains(reqGroup);
    }

    public Class getOwner() {
        return this.owner;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public AccessStrategy getAccess() {
        return this.access;
    }

    public void setAnnotation(T annotation) {
        this.annotation = annotation;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composedConstraints == null ? Collections.EMPTY_SET : this.composedConstraints;
    }

    Set<ConstraintValidation<?>> getComposingValidations() {
        return this.composedConstraints == null ? Collections.EMPTY_SET : this.composedConstraints;
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        if (this.validatorClasses == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.validatorClasses);
    }
}

