/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.ArrayList;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManager;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.ClassValidator;
import org.apache.bval.jsr303.Jsr303MetaBeanFactory;
import org.apache.bval.xml.XMLMetaBeanFactory;

public class ApacheFactoryContext
implements ValidatorContext {
    private final ApacheValidatorFactory factory;
    private final MetaBeanFinder metaBeanFinder;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;

    public ApacheFactoryContext(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.metaBeanFinder = this.buildMetaBeanManager();
    }

    protected ApacheFactoryContext(ApacheValidatorFactory factory, MetaBeanFinder metaBeanFinder) {
        this.factory = factory;
        this.metaBeanFinder = metaBeanFinder;
    }

    public ApacheValidatorFactory getFactory() {
        return this.factory;
    }

    public final MetaBeanFinder getMetaBeanFinder() {
        return this.metaBeanFinder;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory == null ? this.factory.getConstraintValidatorFactory() : this.constraintValidatorFactory;
    }

    public Validator getValidator() {
        ClassValidator validator = new ClassValidator(this);
        if (Boolean.getBoolean(this.factory.getProperties().get("apache.bval.treat-maps-like-beans"))) {
            validator.setTreatMapsLikeBeans(true);
        }
        return validator;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator == null ? this.factory.getMessageInterpolator() : this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver == null ? this.factory.getTraversableResolver() : this.traversableResolver;
    }

    private MetaBeanManager buildMetaBeanManager() {
        ArrayList<MetaBeanFactory> builders = new ArrayList<MetaBeanFactory>(3);
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-introspector"))) {
            builders.add(new IntrospectorMetaBeanFactory());
        }
        builders.add(new Jsr303MetaBeanFactory(this));
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-metabeans-xml"))) {
            builders.add(new XMLMetaBeanFactory());
        }
        return new MetaBeanManager(new MetaBeanBuilder(builders.toArray(new MetaBeanFactory[builders.size()])));
    }
}

