/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.jsr303.groups.GroupsComputer;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.AnnotationProxyBuilder;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationConstraintBuilder {
    private static final Log log = LogFactory.getLog(AnnotationConstraintBuilder.class);
    private static final String ANNOTATION_PAYLOAD = "payload";
    private static final String ANNOTATION_GROUPS = "groups";
    private final ConstraintValidation<?> constraintValidation;
    private List<ConstraintOverrides> overrides;

    public AnnotationConstraintBuilder(Class<? extends ConstraintValidator<?, ?>>[] validatorClasses, ConstraintValidator constraintValidator, Annotation annotation, Class owner, AccessStrategy access) {
        boolean reportFromComposite = annotation != null && annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.constraintValidation = new ConstraintValidation<Annotation>(validatorClasses, constraintValidator, annotation, owner, access, reportFromComposite);
        this.buildFromAnnotation();
    }

    private void buildFromAnnotation() {
        if (this.constraintValidation.getAnnotation() != null) {
            SecureActions.run(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (Method method : AnnotationConstraintBuilder.this.constraintValidation.getAnnotation().annotationType().getDeclaredMethods()) {
                        if (method.getParameterTypes().length != 0) continue;
                        try {
                            if (AnnotationConstraintBuilder.ANNOTATION_PAYLOAD.equals(method.getName())) {
                                AnnotationConstraintBuilder.this.buildPayload(method);
                                continue;
                            }
                            if (AnnotationConstraintBuilder.ANNOTATION_GROUPS.equals(method.getName())) {
                                AnnotationConstraintBuilder.this.buildGroups(method);
                                continue;
                            }
                            AnnotationConstraintBuilder.this.constraintValidation.getAttributes().put(method.getName(), method.invoke(AnnotationConstraintBuilder.this.constraintValidation.getAnnotation(), new Object[0]));
                        }
                        catch (Exception e) {
                            log.warn((Object)("error processing annotation: " + AnnotationConstraintBuilder.this.constraintValidation.getAnnotation()), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void buildGroups(Method method) throws IllegalAccessException, InvocationTargetException {
        Object raw = method.invoke(this.constraintValidation.getAnnotation(), new Object[0]);
        Class[] garr = raw instanceof Class ? new Class[]{(Class)raw} : (raw instanceof Class[] ? (Class[])raw : null);
        garr = garr == null || garr.length == 0 ? GroupsComputer.DEFAULT_GROUP_ARRAY : garr;
        this.constraintValidation.setGroups(new HashSet(Arrays.asList(garr)));
    }

    private void buildPayload(Method method) throws IllegalAccessException, InvocationTargetException {
        Class[] payload_raw = (Class[])method.invoke(this.constraintValidation.getAnnotation(), new Object[0]);
        if (payload_raw == null) {
            this.constraintValidation.setPayload(Collections.<Class<Payload>>emptySet());
        } else {
            HashSet<Class<? extends Payload>> pl = new HashSet<Class<? extends Payload>>(payload_raw.length);
            pl.addAll(Arrays.asList(payload_raw));
            this.constraintValidation.setPayload(pl);
        }
    }

    public ConstraintValidation getConstraintValidation() {
        return this.constraintValidation;
    }

    public void addComposed(ConstraintValidation composite) {
        this.applyOverridesAttributes(composite);
        this.constraintValidation.addComposed(composite);
    }

    private void applyOverridesAttributes(ConstraintValidation<?> composite) {
        if (null == this.overrides) {
            this.buildOverridesAttributes();
        }
        if (!this.overrides.isEmpty()) {
            ConstraintOverrides override;
            int index = this.computeIndex(composite);
            ConstraintOverrides generalOverride = this.findOverride(composite.getAnnotation().annotationType(), -1);
            if (generalOverride != null) {
                if (index > 0) {
                    throw new ConstraintDeclarationException("Wrong OverridesAttribute declaration for " + generalOverride.constraintType + ", it needs a defined index when there is a list of constraints");
                }
                generalOverride.applyOn(composite);
            }
            if ((override = this.findOverride(composite.getAnnotation().annotationType(), index)) != null) {
                override.applyOn(composite);
            }
        }
    }

    private int computeIndex(ConstraintValidation<?> composite) {
        int idx = 0;
        for (ConstraintValidation<?> each : this.constraintValidation.getComposingValidations()) {
            if (each.getAnnotation().annotationType() != composite.getAnnotation().annotationType()) continue;
            ++idx;
        }
        return idx;
    }

    private void buildOverridesAttributes() {
        this.overrides = new LinkedList<ConstraintOverrides>();
        for (Method method : this.constraintValidation.getAnnotation().annotationType().getDeclaredMethods()) {
            OverridesAttribute annoOA;
            OverridesAttribute.List annoOAL = method.getAnnotation(OverridesAttribute.List.class);
            if (annoOAL != null) {
                for (OverridesAttribute annoOA2 : annoOAL.value()) {
                    this.parseConstraintOverride(method.getName(), annoOA2);
                }
            }
            if ((annoOA = method.getAnnotation(OverridesAttribute.class)) == null) continue;
            this.parseConstraintOverride(method.getName(), annoOA);
        }
    }

    private void parseConstraintOverride(String methodName, OverridesAttribute oa) {
        ConstraintOverrides target = this.findOverride(oa.constraint(), oa.constraintIndex());
        if (target == null) {
            target = new ConstraintOverrides(oa.constraint(), oa.constraintIndex());
            this.overrides.add(target);
        }
        target.values.put(oa.name(), this.constraintValidation.getAttributes().get(methodName));
    }

    private ConstraintOverrides findOverride(Class<? extends Annotation> constraint, int constraintIndex) {
        for (ConstraintOverrides each : this.overrides) {
            if (each.constraintType != constraint || each.constraintIndex != constraintIndex) continue;
            return each;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstraintOverrides {
        final Class<? extends Annotation> constraintType;
        final int constraintIndex;
        final Map<String, Object> values;

        private ConstraintOverrides(Class<? extends Annotation> constraintType, int constraintIndex) {
            this.constraintType = constraintType;
            this.constraintIndex = constraintIndex;
            this.values = new HashMap<String, Object>();
        }

        public void applyOn(ConstraintValidation composite) {
            composite.getAttributes().putAll(this.values);
            Object originalAnnot = composite.getAnnotation();
            AnnotationProxyBuilder apb = new AnnotationProxyBuilder(originalAnnot);
            for (String key : this.values.keySet()) {
                apb.putValue(key, this.values.get(key));
            }
            Object newAnnot = apb.createAnnotation();
            composite.setAnnotation(newAnnot);
        }
    }
}

