/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.io.Serializable;
import java.util.Map;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.model.MetaBean;
import org.apache.commons.collections.FastHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanCache
implements MetaBeanFinder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final FastHashMap cacheById = new FastHashMap();
    protected final FastHashMap cacheByClass = new FastHashMap();

    public MetaBeanCache() {
        this.cacheByClass.setFast(true);
        this.cacheById.setFast(true);
    }

    public MetaBeanCache(Map<String, MetaBean> beans) {
        this();
        for (MetaBean bean : beans.values()) {
            this.cache(bean);
        }
    }

    public void clear() {
        this.cacheById.clear();
        this.cacheByClass.clear();
    }

    @Override
    public MetaBean findForId(String beanInfoId) {
        return (MetaBean)this.cacheById.get((Object)beanInfoId);
    }

    @Override
    public MetaBean findForClass(Class<?> clazz) {
        return (MetaBean)this.cacheByClass.get(clazz);
    }

    @Override
    public Map<String, MetaBean> findAll() {
        return this.cacheById;
    }

    public void cache(MetaBean beanInfo) {
        this.cacheById.put((Object)beanInfo.getId(), (Object)beanInfo);
        if (beanInfo.getBeanClass() != null && beanInfo.getId().equals(beanInfo.getBeanClass().getName())) {
            this.cacheByClass.put(beanInfo.getBeanClass(), (Object)beanInfo);
        }
    }

    public void removeFromCache(MetaBean beanInfo) {
        this.cacheById.remove((Object)beanInfo.getId());
        if (beanInfo.getBeanClass() != null && beanInfo.getId().equals(beanInfo.getBeanClass().getName())) {
            this.cacheByClass.remove(beanInfo.getBeanClass());
        }
    }
}

