/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.DynamicMetaBean;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManagerFactory;
import org.apache.bval.Validate;
import org.apache.bval.ValidationResults;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator<T extends ValidationListener> {
    private boolean treatMapsLikeBeans = false;
    private final MetaBeanFinder metaBeanFinder;

    public BeanValidator() {
        this(MetaBeanManagerFactory.getFinder());
    }

    public BeanValidator(MetaBeanFinder metaBeanFinder) {
        this.metaBeanFinder = metaBeanFinder;
    }

    public boolean isTreatMapsLikeBeans() {
        return this.treatMapsLikeBeans;
    }

    public void setTreatMapsLikeBeans(boolean treatMapsLikeBeans) {
        this.treatMapsLikeBeans = treatMapsLikeBeans;
    }

    public T validate(Object bean) {
        MetaBean metaBean = this.getMetaBeanFinder().findForClass(bean.getClass());
        return this.validate(bean, metaBean);
    }

    public T validate(Object bean, MetaBean metaBean) {
        ValidationContext<T> context = this.createContext();
        context.setBean(bean, metaBean);
        this.validateContext(context);
        return context.getListener();
    }

    public T validateCall(Method method, Object[] parameters) {
        if (parameters.length > 0) {
            Annotation[][] annotations = method.getParameterAnnotations();
            ValidationContext<T> context = null;
            block0: for (int i = 0; i < parameters.length; ++i) {
                for (Annotation anno : annotations[i]) {
                    if (!(anno instanceof Validate)) continue;
                    if (context == null) {
                        context = this.createContext();
                    }
                    if (!this.determineMetaBean((Validate)anno, parameters[i], context)) continue;
                    this.validateContext(context);
                    continue block0;
                }
            }
            return context != null ? (T)context.getListener() : null;
        }
        return null;
    }

    protected <VL extends ValidationListener> boolean determineMetaBean(Validate validate, Object parameter, ValidationContext<VL> context) {
        if (validate.value().length() == 0) {
            Class<?> beanClass;
            if (parameter == null) {
                return false;
            }
            if (parameter instanceof Collection) {
                Collection coll = (Collection)parameter;
                if (coll.isEmpty()) {
                    return false;
                }
                beanClass = coll.iterator().next().getClass();
            } else {
                beanClass = parameter.getClass().isArray() ? parameter.getClass().getComponentType() : parameter.getClass();
            }
            context.setBean(parameter, this.getMetaBeanFinder().findForClass(beanClass));
        } else {
            context.setBean(parameter, this.getMetaBeanFinder().findForId(validate.value()));
        }
        return true;
    }

    protected T createResults() {
        return (T)new ValidationResults();
    }

    protected ValidationContext<T> createContext() {
        return new BeanValidationContext<T>(this.createResults());
    }

    public T validateProperty(Object bean, MetaProperty metaProperty) {
        ValidationContext<T> context = this.createContext();
        context.setBean(bean);
        context.setMetaProperty(metaProperty);
        this.validateProperty(context);
        return context.getListener();
    }

    public <VL extends ValidationListener> void validateProperty(ValidationContext<VL> context) {
        for (Validation validation : context.getMetaProperty().getValidations()) {
            validation.validate(context);
        }
    }

    public <VL extends ValidationListener> void validateContext(ValidationContext<VL> context) {
        if (context.getBean() != null) {
            if (!this.treatMapsLikeBeans && context.getBean() instanceof Map) {
                this.validateMapInContext(context);
            } else if (context.getBean() instanceof List) {
                this.validateIteratableInContext(context);
            } else if (context.getBean() instanceof Iterable) {
                this.validateNonPositionalIteratableInContext(context);
            } else if (context.getBean() instanceof Object[]) {
                this.validateArrayInContext(context);
            } else {
                this.validateBeanInContext(context);
            }
        }
    }

    protected <VL extends ValidationListener> void validateBeanInContext(ValidationContext<VL> context) {
        if (this.getDynamicMetaBean(context) != null) {
            context.setMetaBean(this.getDynamicMetaBean(context).resolveMetaBean(context.getBean()));
        }
        this.validateBeanNet(context);
    }

    protected <VL extends ValidationListener> void validateArrayInContext(ValidationContext<VL> context) {
        int index = 0;
        DynamicMetaBean dyn = this.getDynamicMetaBean(context);
        for (Object each : (Object[])context.getBean()) {
            context.setCurrentIndex(index++);
            if (each == null) continue;
            if (dyn != null) {
                context.setBean(each, dyn.resolveMetaBean(each));
            } else {
                context.setBean(each);
            }
            this.validateBeanNet(context);
        }
    }

    private <VL extends ValidationListener> DynamicMetaBean getDynamicMetaBean(ValidationContext<VL> context) {
        return context.getMetaBean() instanceof DynamicMetaBean ? (DynamicMetaBean)context.getMetaBean() : null;
    }

    protected <VL extends ValidationListener> void validateIteratableInContext(ValidationContext<VL> context) {
        Iterator it = ((Iterable)context.getBean()).iterator();
        int index = 0;
        DynamicMetaBean dyn = this.getDynamicMetaBean(context);
        while (it.hasNext()) {
            Object each = it.next();
            context.setCurrentIndex(index++);
            if (each == null) continue;
            if (dyn != null) {
                context.setBean(each, dyn.resolveMetaBean(each));
            } else {
                context.setBean(each);
            }
            this.validateBeanNet(context);
        }
    }

    protected <VL extends ValidationListener> void validateNonPositionalIteratableInContext(ValidationContext<VL> context) {
        Iterator it = ((Iterable)context.getBean()).iterator();
        context.setCurrentIndex(null);
        DynamicMetaBean dyn = this.getDynamicMetaBean(context);
        while (it.hasNext()) {
            Object each = it.next();
            if (each == null) continue;
            if (dyn != null) {
                context.setBean(each, dyn.resolveMetaBean(each));
            } else {
                context.setBean(each);
            }
            this.validateBeanNet(context);
        }
    }

    protected <VL extends ValidationListener> void validateMapInContext(ValidationContext<VL> context) {
        Iterator it = ((Map)context.getBean()).entrySet().iterator();
        DynamicMetaBean dyn = this.getDynamicMetaBean(context);
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            context.setCurrentKey(entry.getKey());
            if (entry.getValue() == null) continue;
            if (dyn != null) {
                context.setBean(entry.getValue(), dyn.resolveMetaBean(entry.getValue()));
            } else {
                context.setBean(entry.getValue());
            }
            this.validateBeanNet(context);
        }
    }

    protected <VL extends ValidationListener> void validateBeanNet(ValidationContext<VL> context) {
        if (context.collectValidated()) {
            this.validateBean(context);
            for (MetaProperty prop : context.getMetaBean().getProperties()) {
                this.validateRelatedBean(context, prop);
            }
        }
    }

    protected <VL extends ValidationListener> void validateRelatedBean(ValidationContext<VL> context, MetaProperty prop) {
        AccessStrategy[] access = (AccessStrategy[])prop.getFeature("refCascade");
        if (access == null && prop.getMetaBean() != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            context.moveDown(prop, new PropertyAccess(bean.getClass(), prop.getName()));
            this.validateContext(context);
            context.moveUp(bean, mbean);
        } else if (access != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            for (AccessStrategy each : access) {
                context.moveDown(prop, each);
                this.validateContext(context);
                context.moveUp(bean, mbean);
            }
        }
    }

    public <VL extends ValidationListener> void validateBean(ValidationContext<VL> context) {
        for (MetaProperty prop : context.getMetaBean().getProperties()) {
            context.setMetaProperty(prop);
            this.validateProperty(context);
        }
        context.setMetaProperty(null);
        for (Validation validation : context.getMetaBean().getValidations()) {
            validation.validate(context);
        }
    }

    public MetaBeanFinder getMetaBeanFinder() {
        return this.metaBeanFinder;
    }
}

