/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.file;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import java.io.IOException;
import org.apache.bval.extras.constraints.file.Symlink;

public class SymlinkValidator
implements ConstraintValidator<Symlink, File> {
    private static final char WINDOWS_SEPARATOR = '\\';

    public boolean isValid(File value, ConstraintValidatorContext context) {
        if (!value.exists()) {
            return false;
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        try {
            File fileInCanonicalDir;
            if (value.getParent() == null) {
                fileInCanonicalDir = value;
            } else {
                File canonicalDir = value.getParentFile().getCanonicalFile();
                fileInCanonicalDir = new File(canonicalDir, value.getName());
            }
            return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public void initialize(Symlink parameters) {
    }
}

