/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.net;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.bval.extras.constraints.net.Domain;

public class DomainValidator
implements ConstraintValidator<Domain, String> {
    private boolean allowLocal;
    private static final Pattern DOMAIN_LABEL = Pattern.compile("\\p{Alnum}(?>[\\p{Alnum}-]*\\p{Alnum})*");
    private static final Pattern DOMAIN_NAME_REGEX = Pattern.compile("^(?:" + DOMAIN_LABEL.pattern() + "\\.)+(\\p{Alpha}{2,})$");
    private static final List<String> INFRASTRUCTURE_TLDS = Arrays.asList("arpa", "root");
    private static final List<String> GENERIC_TLDS = Arrays.asList("aero", "asia", "biz", "cat", "com", "coop", "info", "jobs", "mobi", "museum", "name", "net", "org", "pro", "tel", "travel", "gov", "edu", "mil", "int");
    private static final List<String> COUNTRY_CODE_TLDS = Arrays.asList("ac", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "ax", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "me", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "rs", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "su", "sv", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "um", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "yu", "za", "zm", "zw");
    private static final List<String> LOCAL_TLDS = Arrays.asList("localhost", "localdomain");

    public boolean isValid(String domain, ConstraintValidatorContext context) {
        Matcher matcher = DOMAIN_NAME_REGEX.matcher(domain);
        if (matcher.matches()) {
            domain = matcher.group(1);
            return this.isValidTld(domain);
        }
        return this.allowLocal && DOMAIN_LABEL.matcher(domain).matches();
    }

    boolean isValidTld(String tld) {
        if (this.allowLocal && DomainValidator.isValidLocalTld(tld)) {
            return true;
        }
        return DomainValidator.isValidInfrastructureTld(tld = DomainValidator.chompLeadingDot(tld).toLowerCase()) || DomainValidator.isValidGenericTld(tld) || DomainValidator.isValidCountryCodeTld(tld);
    }

    static boolean isValidInfrastructureTld(String iTld) {
        return INFRASTRUCTURE_TLDS.contains(iTld);
    }

    static boolean isValidGenericTld(String gTld) {
        return GENERIC_TLDS.contains(gTld);
    }

    static boolean isValidCountryCodeTld(String ccTld) {
        return COUNTRY_CODE_TLDS.contains(ccTld);
    }

    static boolean isValidLocalTld(String iTld) {
        return LOCAL_TLDS.contains(iTld);
    }

    private static String chompLeadingDot(String str) {
        if (str.startsWith(".")) {
            return str.substring(1);
        }
        return str;
    }

    public void initialize(Domain domain) {
        this.allowLocal = domain.allowLocal();
    }
}

