/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.file;

import java.io.File;
import java.io.IOException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.bval.extras.constraints.file.Symlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymlinkValidator
implements ConstraintValidator<Symlink, File> {
    private static final char WINDOWS_SEPARATOR = '\\';

    public boolean isValid(File value, ConstraintValidatorContext context) {
        if (!value.exists()) {
            return false;
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        try {
            File fileInCanonicalDir = null;
            if (value.getParent() == null) {
                fileInCanonicalDir = value;
            } else {
                File canonicalDir = value.getParentFile().getCanonicalFile();
                fileInCanonicalDir = new File(canonicalDir, value.getName());
            }
            return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public void initialize(Symlink parameters) {
    }
}

