/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.sdk.v2.sdk.extensions.protobuf;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Duration;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Timestamp;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoSchemaLogicalTypes {
    private static final Schema SCHEMA = Schema.builder().addInt64Field("seconds").addInt32Field("nanos").build();

    public static class SFixed64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "SFixed64";

        SFixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class Fixed64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Fixed64";

        Fixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SInt64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Sint64";

        SInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class UInt64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Uint64";

        UInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SFixed32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "SFixed32";

        SFixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class Fixed32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Fixed32";

        Fixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class SInt32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Sint32";

        SInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class UInt32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Uint32";

        UInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class DurationConvert {
        public static Row toRow(Duration input) {
            return Row.withSchema((Schema)SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static Duration toDuration(Row row) {
            return Duration.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    public static class TimestampConvert {
        public static Row toRow(Timestamp input) {
            return Row.withSchema((Schema)SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static Timestamp toTimestamp(Row row) {
            return Timestamp.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }
}

