/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.util.EmptyOnDeserializationThreadLocal;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class JAXBCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Class<T> jaxbClass;
    private volatile transient @UnknownKeyFor @NonNull @Initialized JAXBContext jaxbContext;
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized Marshaller> jaxbMarshaller;
    private final @UnknownKeyFor @NonNull @Initialized EmptyOnDeserializationThreadLocal<@UnknownKeyFor @NonNull @Initialized Unmarshaller> jaxbUnmarshaller;

    public @UnknownKeyFor @NonNull @Initialized Class<T> getJAXBClass() {
        return this.jaxbClass;
    }

    private JAXBCoder(@UnknownKeyFor @NonNull @Initialized Class<T> jaxbClass) {
        this.jaxbClass = jaxbClass;
        this.jaxbMarshaller = new EmptyOnDeserializationThreadLocal<Marshaller>(){

            protected @UnknownKeyFor @NonNull @Initialized Marshaller initialValue() {
                try {
                    JAXBContext jaxbContext = JAXBCoder.this.getContext();
                    return jaxbContext.createMarshaller();
                }
                catch (JAXBException e) {
                    throw new RuntimeException("Error when creating marshaller from JAXB Context.", e);
                }
            }
        };
        this.jaxbUnmarshaller = new EmptyOnDeserializationThreadLocal<Unmarshaller>(){

            protected @UnknownKeyFor @NonNull @Initialized Unmarshaller initialValue() {
                try {
                    JAXBContext jaxbContext = JAXBCoder.this.getContext();
                    return jaxbContext.createUnmarshaller();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error when creating unmarshaller from JAXB Context.", e);
                }
            }
        };
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JAXBCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> jaxbClass) {
        return new JAXBCoder<T>(jaxbClass);
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (context.isWholeStream) {
            try {
                ((Marshaller)this.jaxbMarshaller.get()).marshal(value, (OutputStream)new CloseIgnoringOutputStream(outStream));
            }
            catch (JAXBException e) {
                throw new CoderException((Throwable)e);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((Marshaller)this.jaxbMarshaller.get()).marshal(value, (OutputStream)baos);
        }
        catch (JAXBException e) {
            throw new CoderException((Throwable)e);
        }
        VarInt.encode((int)baos.size(), (OutputStream)outStream);
        baos.writeTo(outStream);
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            if (!context.isWholeStream) {
                long limit = VarInt.decodeLong((InputStream)inStream);
                inStream = ByteStreams.limit((InputStream)inStream, (long)limit);
            }
            Object obj = ((Unmarshaller)this.jaxbUnmarshaller.get()).unmarshal((InputStream)new CloseIgnoringInputStream(inStream));
            return (T)obj;
        }
        catch (JAXBException e) {
            throw new CoderException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized JAXBContext getContext() throws @UnknownKeyFor @NonNull @Initialized JAXBException {
        if (this.jaxbContext == null) {
            JAXBCoder jAXBCoder = this;
            synchronized (jAXBCoder) {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.jaxbClass});
                }
            }
        }
        return this.jaxbContext;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(this.jaxbClass);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JAXBCoder)) {
            return false;
        }
        JAXBCoder that = (JAXBCoder)((Object)other);
        return Objects.equals(this.jaxbClass, that.jaxbClass);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.jaxbClass.hashCode();
    }

    private static class CloseIgnoringOutputStream
    extends FilterOutputStream {
        CloseIgnoringOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream out) {
            super(out);
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() {
        }
    }

    private static class CloseIgnoringInputStream
    extends FilterInputStream {
        CloseIgnoringInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

