/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.tika.TikaIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdks.java.io.tika.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.io.tika.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.io.tika.repackaged.com.google.common.collect.Iterables;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TikaSource
extends BoundedSource<String> {
    private static final long serialVersionUID = -509574062910491122L;
    private static final Logger LOG = LoggerFactory.getLogger(TikaSource.class);
    @Nullable
    private MatchResult.Metadata singleFileMetadata;
    private final Mode mode;
    private final TikaIO.Read spec;

    TikaSource(TikaIO.Read spec) {
        this.mode = Mode.FILEPATTERN;
        this.spec = spec;
    }

    TikaSource(MatchResult.Metadata fileMetadata, TikaIO.Read spec) {
        this.mode = Mode.SINGLE_FILE;
        this.singleFileMetadata = Preconditions.checkNotNull(fileMetadata, "fileMetadata");
        this.spec = spec;
    }

    public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) throws IOException {
        this.validate();
        Preconditions.checkState(this.spec.getFilepattern().isAccessible(), "Cannot create a Tika reader without access to the file or pattern specification: {}.", this.spec.getFilepattern());
        if (this.spec.getTikaConfigPath() != null) {
            Preconditions.checkState(this.spec.getTikaConfigPath().isAccessible(), "Cannot create a Tika reader without access to its configuration", this.spec.getTikaConfigPath());
        }
        String fileOrPattern = (String)this.spec.getFilepattern().get();
        if (this.mode == Mode.FILEPATTERN) {
            List<MatchResult.Metadata> fileMetadata = TikaSource.expandFilePattern(fileOrPattern);
            ArrayList<TikaReader> fileReaders = new ArrayList<TikaReader>();
            for (MatchResult.Metadata metadata : fileMetadata) {
                fileReaders.add(new TikaReader(this, metadata.resourceId().toString()));
            }
            if (fileReaders.size() == 1) {
                return (BoundedSource.BoundedReader)fileReaders.get(0);
            }
            return new FilePatternTikaReader(this, fileReaders);
        }
        return new TikaReader(this, this.singleFileMetadata.resourceId().toString());
    }

    public List<? extends TikaSource> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        if (this.mode == Mode.SINGLE_FILE) {
            return ImmutableList.of(this);
        }
        List<MatchResult.Metadata> fileMetadata = TikaSource.expandFilePattern((String)this.spec.getFilepattern().get());
        LinkedList<TikaSource> splitResults = new LinkedList<TikaSource>();
        for (MatchResult.Metadata metadata : fileMetadata) {
            splitResults.add(new TikaSource(metadata, this.spec));
        }
        return splitResults;
    }

    public TikaIO.Read getTikaInputRead() {
        return this.spec;
    }

    public Coder<String> getDefaultOutputCoder() {
        return StringUtf8Coder.of();
    }

    public void validate() {
        switch (this.mode) {
            case FILEPATTERN: {
                Preconditions.checkArgument(this.singleFileMetadata == null, "Unexpected initialized singleFileMetadata value");
                break;
            }
            case SINGLE_FILE: {
                Preconditions.checkNotNull(this.singleFileMetadata, "Unexpected null singleFileMetadata value");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
            }
        }
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        long totalSize = 0L;
        List<MatchResult.Metadata> fileMetadata = TikaSource.expandFilePattern((String)this.spec.getFilepattern().get());
        for (MatchResult.Metadata metadata : fileMetadata) {
            totalSize += metadata.sizeBytes();
        }
        return totalSize;
    }

    Mode getMode() {
        return this.mode;
    }

    MatchResult.Metadata getSingleFileMetadata() {
        return this.singleFileMetadata;
    }

    private static List<MatchResult.Metadata> expandFilePattern(String fileOrPattern) throws IOException {
        MatchResult matches = (MatchResult)Iterables.getOnlyElement(FileSystems.match(Collections.singletonList(fileOrPattern)));
        LOG.info("Matched {} files for pattern {}", (Object)matches.metadata().size(), (Object)fileOrPattern);
        ImmutableList<MatchResult.Metadata> metadata = ImmutableList.copyOf(matches.metadata());
        Preconditions.checkArgument(!metadata.isEmpty(), "Unable to find any files matching %s", (Object)fileOrPattern);
        return metadata;
    }

    static class ContentHandlerImpl
    extends DefaultHandler {
        private Queue<String> queue = new ConcurrentLinkedQueue<String>();
        private volatile boolean documentEnded;
        private volatile Exception parseException;
        private volatile String current;
        private int minTextLength;

        ContentHandlerImpl() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length).trim();
            if (!value.isEmpty()) {
                if (this.minTextLength <= 0) {
                    this.queue.add(value);
                } else {
                    String string = this.current = this.current == null ? value : this.current + " " + value;
                    if (this.current.length() >= this.minTextLength) {
                        this.queue.add(this.current);
                        this.current = null;
                    }
                }
            }
        }

        public void setParseException(Exception ex) {
            this.parseException = ex;
        }

        public synchronized boolean waitForNext(long pollTime) throws IOException {
            if (!this.documentEnded) {
                try {
                    this.wait(pollTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.documentEnded;
        }

        @Override
        public synchronized void endDocument() throws SAXException {
            this.documentEnded = true;
            this.notify();
        }

        public String getCurrent() throws IOException {
            this.checkParseException();
            String value = this.queue.poll();
            if (value == null && this.documentEnded) {
                return this.current;
            }
            return value;
        }

        public void checkParseException() throws IOException {
            if (this.parseException != null) {
                throw new IOException(this.parseException);
            }
        }

        public void setMinTextLength(int minTextLength) {
            this.minTextLength = minTextLength;
        }
    }

    static class TikaReader
    extends BoundedSource.BoundedReader<String> {
        private ExecutorService execService;
        private final ContentHandlerImpl tikaHandler = new ContentHandlerImpl();
        private String current;
        private TikaSource source;
        private String filePath;
        private TikaIO.Read spec;
        private Metadata tikaMetadata;
        private Iterator<String> metadataIterator;

        TikaReader(TikaSource source, String filePath) {
            this.source = source;
            this.filePath = filePath;
            this.spec = source.getTikaInputRead();
        }

        public boolean start() throws IOException {
            TikaInputStream is = TikaInputStream.get((Path)Paths.get(this.filePath, new String[0]));
            TikaConfig tikaConfig = null;
            if (this.spec.getTikaConfigPath() != null) {
                try {
                    tikaConfig = new TikaConfig((String)this.spec.getTikaConfigPath().get());
                }
                catch (TikaException | SAXException e) {
                    throw new IOException(e);
                }
            }
            AutoDetectParser parser = tikaConfig == null ? new AutoDetectParser() : new AutoDetectParser(tikaConfig);
            ParseContext context = new ParseContext();
            context.set(Parser.class, (Object)parser);
            Metadata metadata = this.tikaMetadata = this.spec.getInputMetadata() != null ? this.spec.getInputMetadata() : new Metadata();
            if (this.spec.getMinimumTextLength() != null) {
                this.tikaHandler.setMinTextLength(this.spec.getMinimumTextLength());
            }
            if (!Boolean.TRUE.equals(this.spec.getParseSynchronously())) {
                this.execService = Executors.newFixedThreadPool(1);
                this.execService.submit(new Runnable((Parser)parser, (InputStream)is, context){
                    final /* synthetic */ Parser val$parser;
                    final /* synthetic */ InputStream val$is;
                    final /* synthetic */ ParseContext val$context;
                    {
                        this.val$parser = parser;
                        this.val$is = inputStream;
                        this.val$context = parseContext;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$parser.parse(this.val$is, (ContentHandler)tikaHandler, tikaMetadata, this.val$context);
                            this.val$is.close();
                        }
                        catch (Exception ex) {
                            tikaHandler.setParseException(ex);
                        }
                    }
                });
            } else {
                try {
                    parser.parse((InputStream)is, (ContentHandler)this.tikaHandler, this.tikaMetadata, context);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
                finally {
                    is.close();
                }
            }
            return this.advanceToNext();
        }

        public boolean advance() throws IOException {
            Preconditions.checkState(this.current != null, "Call start() before advance()");
            return this.advanceToNext();
        }

        protected boolean advanceToNext() throws IOException {
            this.current = null;
            if (this.metadataIterator == null) {
                this.current = this.tikaHandler.getCurrent();
                if (this.current == null && !Boolean.TRUE.equals(this.spec.getParseSynchronously())) {
                    long configuredPollTime;
                    long configuredMaxPollTime = this.spec.getQueueMaxPollTime() == null ? 3000L : this.spec.getQueueMaxPollTime();
                    long l = configuredPollTime = this.spec.getQueuePollTime() == null ? 50L : this.spec.getQueuePollTime();
                    for (long maxPollTime = 0L; this.current == null && maxPollTime < configuredMaxPollTime; maxPollTime += this.spec.getQueuePollTime().longValue()) {
                        boolean docEnded = this.tikaHandler.waitForNext(configuredPollTime);
                        this.current = this.tikaHandler.getCurrent();
                        if (docEnded) break;
                    }
                }
                if (this.current == null && Boolean.TRUE.equals(this.spec.getReadOutputMetadata())) {
                    this.metadataIterator = Arrays.asList(this.tikaMetadata.names()).iterator();
                }
            }
            if (this.metadataIterator != null && this.metadataIterator.hasNext()) {
                String key = this.metadataIterator.next();
                this.current = key + "=" + this.tikaMetadata.get(key);
            }
            return this.current != null;
        }

        public String getCurrent() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void close() throws IOException {
            if (this.execService != null) {
                this.execService.shutdown();
            }
        }

        ExecutorService getExecutorService() {
            return this.execService;
        }

        public BoundedSource<String> getCurrentSource() {
            return this.source;
        }
    }

    static class FilePatternTikaReader
    extends BoundedSource.BoundedReader<String> {
        private final TikaSource source;
        final ListIterator<TikaReader> fileReadersIterator;
        TikaReader currentReader = null;

        public FilePatternTikaReader(TikaSource source, List<TikaReader> fileReaders) {
            this.source = source;
            this.fileReadersIterator = fileReaders.listIterator();
        }

        public boolean start() throws IOException {
            return this.startNextNonemptyReader();
        }

        public boolean advance() throws IOException {
            Preconditions.checkState(this.currentReader != null, "Call start() before advance()");
            if (this.currentReader.advance()) {
                return true;
            }
            return this.startNextNonemptyReader();
        }

        private boolean startNextNonemptyReader() throws IOException {
            while (this.fileReadersIterator.hasNext()) {
                this.currentReader = this.fileReadersIterator.next();
                if (this.currentReader.start()) {
                    return true;
                }
                this.currentReader.close();
            }
            return false;
        }

        public String getCurrent() throws NoSuchElementException {
            return this.currentReader.getCurrent();
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.currentReader.getCurrentTimestamp();
        }

        public void close() throws IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
            }
            while (this.fileReadersIterator.hasNext()) {
                this.fileReadersIterator.next().close();
            }
        }

        public TikaSource getCurrentSource() {
            return this.source;
        }
    }

    public static enum Mode {
        FILEPATTERN,
        SINGLE_FILE;

    }
}

