/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.thrift.ThriftCoder;
import org.apache.beam.sdk.io.thrift.ThriftSchema;
import org.apache.beam.sdk.schemas.RowMessages;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.schemas.transforms.Cast;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocolFactory;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={PayloadSerializerProvider.class})
public class ThriftPayloadSerializerProvider
implements PayloadSerializerProvider {
    public String identifier() {
        return "thrift";
    }

    private static Class<? extends TBase> getMessageClass(Map<String, Object> tableParams) {
        String thriftClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("thriftClass")).toString();
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass.asSubclass(TBase.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect thrift class provided: " + thriftClassName, e);
        }
    }

    private static TProtocolFactory getProtocolFactory(Map<String, Object> tableParams) {
        String thriftFactoryClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("thriftProtocolFactoryClass")).toString();
        try {
            Class<?> thriftClass = Class.forName(thriftFactoryClassName);
            return thriftClass.asSubclass(TProtocolFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Incorrect thrift protocol factory class provided: " + thriftFactoryClassName, e);
        }
    }

    private static void inferAndVerifySchema(Class<?> thriftClass, Schema requiredSchema) {
        TypeDescriptor typeDescriptor = TypeDescriptor.of(thriftClass);
        Schema schema = (Schema)Preconditions.checkArgumentNotNull((Object)ThriftSchema.provider().schemaFor(typeDescriptor));
        if (!schema.assignableTo(requiredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from thrift class.%nThrift class: '%s'%nInferred schema: '%s'", requiredSchema, thriftClass.getName(), schema));
        }
    }

    private static <T extends TBase> PayloadSerializer getPayloadSerializer(Schema schema, TProtocolFactory protocolFactory, Class<T> thriftClass) {
        ThriftCoder<T> coder = ThriftCoder.of(thriftClass, protocolFactory);
        TypeDescriptor descriptor = TypeDescriptor.of(thriftClass);
        SimpleFunction toRowFn = RowMessages.bytesToRowFn((SchemaProvider)ThriftSchema.provider(), (TypeDescriptor)descriptor, coder);
        return PayloadSerializer.of((SerializableFunction)RowMessages.rowToBytesFn((SchemaProvider)ThriftSchema.provider(), (TypeDescriptor)descriptor, coder), (SerializableFunction & Serializable)bytes -> {
            Row rawRow = (Row)toRowFn.apply(bytes);
            return Cast.castRow((Row)rawRow, (Schema)rawRow.getSchema(), (Schema)schema);
        });
    }

    public PayloadSerializer getSerializer(Schema schema, Map<String, Object> tableParams) {
        Class<? extends TBase> thriftClass = ThriftPayloadSerializerProvider.getMessageClass(tableParams);
        TProtocolFactory protocolFactory = ThriftPayloadSerializerProvider.getProtocolFactory(tableParams);
        ThriftPayloadSerializerProvider.inferAndVerifySchema(thriftClass, schema);
        return ThriftPayloadSerializerProvider.getPayloadSerializer(schema, protocolFactory, thriftClass);
    }
}

