/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.thrift;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

class ThriftCoder<T>
extends CustomCoder<T> {
    private final Class<T> type;
    private final TProtocolFactory protocolFactory;

    protected ThriftCoder(Class<T> type, TProtocolFactory protocolFactory) {
        this.type = type;
        this.protocolFactory = protocolFactory;
    }

    static <T> ThriftCoder<T> of(Class<T> clazz, TProtocolFactory protocolFactory) {
        return new ThriftCoder<T>(clazz, protocolFactory);
    }

    public void encode(T value, OutputStream outStream) throws CoderException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        try {
            TBase tBase = (TBase)value;
            tBase.write(protocol);
        }
        catch (Exception te) {
            throw new CoderException("Could not write value. Error: " + te.getMessage());
        }
        outStream.write(baos.toByteArray());
    }

    public T decode(InputStream inStream) throws CoderException, IOException {
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport(inStream));
            TBase value = (TBase)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            value.read(protocol);
            return (T)value;
        }
        catch (Exception te) {
            throw new CoderException("Could not read value. Error: " + te.getMessage());
        }
    }
}

