/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SnowflakeColumn
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType;
    private @UnknownKeyFor @NonNull @Initialized String name;
    private @UnknownKeyFor @NonNull @Initialized boolean isNullable;

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeColumn of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType) {
        return new SnowflakeColumn(name, dataType);
    }

    public static @UnknownKeyFor @NonNull @Initialized SnowflakeColumn of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType, @UnknownKeyFor @NonNull @Initialized boolean isNull) {
        return new SnowflakeColumn(name, dataType, isNull);
    }

    public SnowflakeColumn() {
    }

    public SnowflakeColumn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public SnowflakeColumn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType, @UnknownKeyFor @NonNull @Initialized boolean isNullable) {
        this.dataType = dataType;
        this.name = name;
        this.isNullable = isNullable;
    }

    public @UnknownKeyFor @NonNull @Initialized String sql() {
        String sql = String.format("%s %s", this.name, this.dataType.sql());
        if (this.isNullable) {
            sql = sql + " NULL";
        }
        return sql;
    }

    public @UnknownKeyFor @NonNull @Initialized SnowflakeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(@UnknownKeyFor @NonNull @Initialized SnowflakeDataType dataType) {
        this.dataType = dataType;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
        this.name = name;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(@UnknownKeyFor @NonNull @Initialized boolean nullable) {
        this.isNullable = nullable;
    }
}

