/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data;

import java.io.Serializable;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonProperty;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeColumn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;

public class SnowflakeTableSchema
implements Serializable {
    @JsonProperty(value="schema")
    private SnowflakeColumn[] columns;

    public static SnowflakeTableSchema of(SnowflakeColumn ... columns) {
        return new SnowflakeTableSchema(columns);
    }

    public SnowflakeTableSchema() {
    }

    public SnowflakeTableSchema(SnowflakeColumn ... columns) {
        this.columns = columns;
    }

    public String sql() {
        ArrayList<String> columnsSqls = new ArrayList<String>();
        for (SnowflakeColumn column : this.columns) {
            columnsSqls.add(column.sql());
        }
        return Joiner.on((String)", ").join(columnsSqls);
    }

    public SnowflakeColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(SnowflakeColumn[] columns) {
        this.columns = columns;
    }
}

