/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.credentials;

import org.apache.beam.sdk.io.snowflake.SnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.credentials.KeyPairSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.OAuthTokenSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.UsernamePasswordSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.crosslanguage.SnowflakeReadRegistrar;

public class SnowflakeCredentialsFactory {
    public static SnowflakeCredentials of(SnowflakePipelineOptions o) {
        if (SnowflakeCredentialsFactory.oauthOptionsAvailable(o.getOauthToken())) {
            return new OAuthTokenSnowflakeCredentials(o.getOauthToken());
        }
        if (SnowflakeCredentialsFactory.usernamePasswordOptionsAvailable(o.getUsername(), o.getPassword())) {
            return new UsernamePasswordSnowflakeCredentials(o.getUsername(), o.getPassword());
        }
        if (SnowflakeCredentialsFactory.keyPairOptionsAvailable(o.getUsername(), o.getPrivateKeyPath(), o.getPrivateKeyPassphrase())) {
            return new KeyPairSnowflakeCredentials(o.getUsername(), o.getPrivateKeyPath(), o.getPrivateKeyPassphrase());
        }
        throw new RuntimeException("Can't get credentials from Options");
    }

    public static SnowflakeCredentials of(SnowflakeReadRegistrar.ReadConfiguration c) {
        if (SnowflakeCredentialsFactory.oauthOptionsAvailable(c.getOAuthToken())) {
            return new OAuthTokenSnowflakeCredentials(c.getOAuthToken());
        }
        if (SnowflakeCredentialsFactory.usernamePasswordOptionsAvailable(c.getUsername(), c.getPassword())) {
            return new UsernamePasswordSnowflakeCredentials(c.getUsername(), c.getPassword());
        }
        if (SnowflakeCredentialsFactory.keyPairOptionsAvailable(c.getUsername(), c.getPrivateKeyPath(), c.getPrivateKeyPassphrase())) {
            return new KeyPairSnowflakeCredentials(c.getUsername(), c.getPrivateKeyPath(), c.getPrivateKeyPassphrase());
        }
        throw new RuntimeException("Can't get credentials from Options");
    }

    private static boolean oauthOptionsAvailable(String token) {
        return token != null && !token.isEmpty();
    }

    private static boolean usernamePasswordOptionsAvailable(String username, String password) {
        return username != null && !username.isEmpty() && !password.isEmpty();
    }

    private static boolean keyPairOptionsAvailable(String username, String privateKeyPath, String privateKeyPassphrase) {
        return username != null && !username.isEmpty() && !privateKeyPath.isEmpty() && !privateKeyPassphrase.isEmpty();
    }
}

