/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import com.google.auto.value.AutoValue;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Read;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Write;
import org.apache.beam.sdk.io.snowflake.credentials.KeyPairSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.OAuthTokenSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.SnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.credentials.UsernamePasswordSnowflakeCredentials;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeService;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServiceImpl;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SnowflakeIO {
    private static final Logger LOG = LoggerFactory.getLogger(SnowflakeIO.class);
    private static final String CSV_QUOTE_CHAR = "'";
    private static final String WRITE_TMP_PATH = "data";

    public static <T> Read<T> read(SnowflakeService snowflakeService) {
        return new AutoValue_SnowflakeIO_Read.Builder().setSnowflakeService(snowflakeService).build();
    }

    public static <T> Read<T> read() {
        return SnowflakeIO.read(new SnowflakeServiceImpl());
    }

    public static <T> Write<T> write() {
        return new AutoValue_SnowflakeIO_Write.Builder().setFileNameTemplate("output").setWriteDisposition(WriteDisposition.APPEND).build();
    }

    public static class DataSourceProviderFromDataSourceConfiguration
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final ConcurrentHashMap<DataSourceConfiguration, DataSource> instances = new ConcurrentHashMap();
        private final DataSourceConfiguration config;

        private DataSourceProviderFromDataSourceConfiguration(DataSourceConfiguration config) {
            if (config.getValidate().booleanValue()) {
                try {
                    Connection connection = config.buildDatasource().getConnection();
                    connection.close();
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException("Invalid DataSourceConfiguration. Underlying cause: " + e);
                }
            }
            this.config = config;
        }

        public static SerializableFunction<Void, DataSource> of(DataSourceConfiguration config) {
            return new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public DataSource apply(Void input) {
            return instances.computeIfAbsent(this.config, config -> config.buildDatasource());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }
    }

    @AutoValue
    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        public abstract String getUrl();

        @Nullable
        public abstract String getUsername();

        @Nullable
        public abstract String getPassword();

        @Nullable
        public abstract PrivateKey getPrivateKey();

        @Nullable
        public abstract String getOauthToken();

        @Nullable
        public abstract String getDatabase();

        @Nullable
        public abstract String getWarehouse();

        @Nullable
        public abstract String getSchema();

        @Nullable
        public abstract String getServerName();

        @Nullable
        public abstract Integer getPortNumber();

        @Nullable
        public abstract String getRole();

        @Nullable
        public abstract Integer getLoginTimeout();

        @Nullable
        public abstract Boolean getSsl();

        @Nullable
        public abstract Boolean getValidate();

        @Nullable
        public abstract DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setDataSource(dataSource).build();
        }

        public static DataSourceConfiguration create(SnowflakeCredentials credentials) {
            if (credentials instanceof UsernamePasswordSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setUsername(((UsernamePasswordSnowflakeCredentials)credentials).getUsername()).setPassword(((UsernamePasswordSnowflakeCredentials)credentials).getPassword()).build();
            }
            if (credentials instanceof OAuthTokenSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setOauthToken(((OAuthTokenSnowflakeCredentials)credentials).getToken()).build();
            }
            if (credentials instanceof KeyPairSnowflakeCredentials) {
                return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setValidate(true).setUsername(((KeyPairSnowflakeCredentials)credentials).getUsername()).setPrivateKey(((KeyPairSnowflakeCredentials)credentials).getPrivateKey()).build();
            }
            throw new IllegalArgumentException("Can't create DataSourceConfiguration from given credentials");
        }

        public DataSourceConfiguration withUrl(String url) {
            Preconditions.checkArgument((boolean)url.startsWith("jdbc:snowflake://"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            Preconditions.checkArgument((boolean)url.endsWith("snowflakecomputing.com"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            return this.builder().setUrl(url).build();
        }

        public DataSourceConfiguration withDatabase(String database) {
            return this.builder().setDatabase(database).build();
        }

        public DataSourceConfiguration withWarehouse(String warehouse) {
            return this.builder().setWarehouse(warehouse).build();
        }

        public DataSourceConfiguration withSchema(String schema) {
            return this.builder().setSchema(schema).build();
        }

        public DataSourceConfiguration withServerName(String serverName) {
            Preconditions.checkArgument((boolean)serverName.endsWith("snowflakecomputing.com"), (Object)"serverName must be in format <account_name>.snowflakecomputing.com");
            return this.builder().setServerName(serverName).build();
        }

        public DataSourceConfiguration withPortNumber(Integer portNumber) {
            return this.builder().setPortNumber(portNumber).build();
        }

        public DataSourceConfiguration withRole(String role) {
            return this.builder().setRole(role).build();
        }

        public DataSourceConfiguration withLoginTimeout(Integer loginTimeout) {
            return this.builder().setLoginTimeout(loginTimeout).build();
        }

        public DataSourceConfiguration withoutValidation() {
            return this.builder().setValidate(false).build();
        }

        void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            }
        }

        public DataSource buildDatasource() {
            if (this.getDataSource() == null) {
                SnowflakeBasicDataSource basicDataSource = new SnowflakeBasicDataSource();
                if (this.getUrl() != null) {
                    basicDataSource.setUrl(this.getUrl());
                }
                if (this.getUsername() != null) {
                    basicDataSource.setUser(this.getUsername());
                }
                if (this.getPassword() != null) {
                    basicDataSource.setPassword(this.getPassword());
                }
                if (this.getPrivateKey() != null) {
                    basicDataSource.setPrivateKey(this.getPrivateKey());
                }
                if (this.getDatabase() != null) {
                    basicDataSource.setDatabaseName(this.getDatabase());
                }
                if (this.getWarehouse() != null) {
                    basicDataSource.setWarehouse(this.getWarehouse());
                }
                if (this.getSchema() != null) {
                    basicDataSource.setSchema(this.getSchema());
                }
                if (this.getServerName() != null) {
                    basicDataSource.setServerName(this.getServerName());
                }
                if (this.getPortNumber() != null) {
                    basicDataSource.setPortNumber(this.getPortNumber().intValue());
                }
                if (this.getRole() != null) {
                    basicDataSource.setRole(this.getRole());
                }
                if (this.getLoginTimeout() != null) {
                    try {
                        basicDataSource.setLoginTimeout(this.getLoginTimeout().intValue());
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to setLoginTimeout");
                    }
                }
                if (this.getOauthToken() != null) {
                    basicDataSource.setOauthToken(this.getOauthToken());
                }
                return basicDataSource;
            }
            return this.getDataSource();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUrl(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setPrivateKey(PrivateKey var1);

            abstract Builder setOauthToken(String var1);

            abstract Builder setDatabase(String var1);

            abstract Builder setWarehouse(String var1);

            abstract Builder setSchema(String var1);

            abstract Builder setServerName(String var1);

            abstract Builder setPortNumber(Integer var1);

            abstract Builder setRole(String var1);

            abstract Builder setLoginTimeout(Integer var1);

            abstract Builder setSsl(Boolean var1);

            abstract Builder setValidate(Boolean var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    private static class CopyToTableFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final String table;
        private final String query;
        private final String stagingBucketDir;
        private final String storageIntegrationName;
        private final WriteDisposition writeDisposition;
        private final SnowflakeService snowflakeService;

        CopyToTableFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, String table, String query, String stagingBucketDir, String storageIntegrationName, WriteDisposition writeDisposition, SnowflakeService snowflakeService) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.table = table;
            this.query = query;
            this.stagingBucketDir = stagingBucketDir;
            this.storageIntegrationName = storageIntegrationName;
            this.writeDisposition = writeDisposition;
            this.snowflakeService = snowflakeService;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            SnowflakeServiceConfig config = new SnowflakeServiceConfig(this.dataSourceProviderFn, (List)context.element(), this.table, this.query, this.writeDisposition, this.storageIntegrationName, this.stagingBucketDir);
            this.snowflakeService.write(config);
        }
    }

    private static class MapObjectsArrayToCsvFn
    extends DoFn<Object[], String> {
        private MapObjectsArrayToCsvFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            ArrayList<Object> csvItems = new ArrayList<Object>();
            for (Object o : (Object[])context.element()) {
                if (o instanceof String) {
                    String field = (String)o;
                    field = field.replace(SnowflakeIO.CSV_QUOTE_CHAR, "''");
                    field = this.quoteField(field);
                    csvItems.add(field);
                    continue;
                }
                csvItems.add(o);
            }
            context.output((Object)Joiner.on((String)",").useForNull("").join(csvItems));
        }

        private String quoteField(String field) {
            return this.quoteField(field, SnowflakeIO.CSV_QUOTE_CHAR);
        }

        private String quoteField(String field, String quotation) {
            return String.format("%s%s%s", quotation, field, quotation);
        }
    }

    public static class Concatenate
    extends Combine.CombineFn<String, List<String>, List<String>> {
        public List<String> createAccumulator() {
            return new ArrayList<String>();
        }

        public List<String> addInput(List<String> mutableAccumulator, String input) {
            mutableAccumulator.add(String.format("'%s'", input));
            return mutableAccumulator;
        }

        public List<String> mergeAccumulators(Iterable<List<String>> accumulators) {
            Object result = this.createAccumulator();
            for (List<String> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        public List<String> extractOutput(List<String> accumulator) {
            return accumulator;
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        @Nullable
        abstract String getTable();

        @Nullable
        abstract String getStorageIntegrationName();

        @Nullable
        abstract String getStagingBucketName();

        @Nullable
        abstract String getQuery();

        @Nullable
        abstract String getFileNameTemplate();

        @Nullable
        abstract WriteDisposition getWriteDisposition();

        @Nullable
        abstract UserDataMapper getUserDataMapper();

        @Nullable
        abstract SnowflakeService getSnowflakeService();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public Write<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Write<T> withTable(String table) {
            return this.toBuilder().setTable(table).build();
        }

        public Write<T> withStagingBucketName(String stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Write<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Write<T> withQueryTransformation(String query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Write<T> withFileNameTemplate(String fileNameTemplate) {
            return this.toBuilder().setFileNameTemplate(fileNameTemplate).build();
        }

        public Write<T> withUserDataMapper(UserDataMapper userDataMapper) {
            return this.toBuilder().setUserDataMapper(userDataMapper).build();
        }

        public Write<T> withWriteDisposition(WriteDisposition writeDisposition) {
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public Write<T> withSnowflakeService(SnowflakeService snowflakeService) {
            return this.toBuilder().setSnowflakeService(snowflakeService).build();
        }

        public PDone expand(PCollection<T> input) {
            this.checkArguments();
            String stagingBucketDir = String.format("%s/%s/", this.getStagingBucketName(), SnowflakeIO.WRITE_TMP_PATH);
            PCollection<String> out = this.write(input, stagingBucketDir);
            out.setCoder((Coder)StringUtf8Coder.of());
            return PDone.in((Pipeline)out.getPipeline());
        }

        private void checkArguments() {
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName is required");
            Preconditions.checkArgument((this.getUserDataMapper() != null ? 1 : 0) != 0, (Object)"withUserDataMapper() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"withTable() is required");
        }

        private PCollection<String> write(PCollection<T> input, String stagingBucketDir) {
            SnowflakeService snowflakeService = this.getSnowflakeService() != null ? this.getSnowflakeService() : new SnowflakeServiceImpl();
            PCollection files = this.writeFiles(input, stagingBucketDir);
            ListCoder coder = ListCoder.of((Coder)StringUtf8Coder.of());
            files = (PCollection)files.getPipeline().apply(Reify.viewInGlobalWindow((PCollectionView)((PCollectionView)files.apply((PTransform)View.asList())), (Coder)coder));
            return (PCollection)files.apply("Copy files to table", this.copyToTable(snowflakeService, stagingBucketDir));
        }

        private PCollection<String> writeFiles(PCollection<T> input, String stagingBucketDir) {
            PCollection mappedUserData = ((PCollection)((PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<T, Object[]>(){

                public Object[] apply(T element) {
                    return this.getUserDataMapper().mapRow(element);
                }
            }))).apply("Map Objects array to CSV lines", (PTransform)ParDo.of((DoFn)new MapObjectsArrayToCsvFn()))).setCoder((Coder)StringUtf8Coder.of());
            WriteFilesResult filesResult = (WriteFilesResult)mappedUserData.apply("Write files to specified location", (PTransform)FileIO.write().via((FileIO.Sink)TextIO.sink()).to(stagingBucketDir).withPrefix(this.getFileNameTemplate()).withSuffix(".csv").withCompression(Compression.GZIP));
            return (PCollection)filesResult.getPerDestinationOutputFilenames().apply("Parse KV filenames to Strings", (PTransform)Values.create());
        }

        private ParDo.SingleOutput<Object, Object> copyToTable(SnowflakeService snowflakeService, String stagingBucketDir) {
            return ParDo.of(new CopyToTableFn(this.getDataSourceProviderFn(), this.getTable(), this.getQuery(), stagingBucketDir, this.getStorageIntegrationName(), this.getWriteDisposition(), snowflakeService));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setTable(String var1);

            abstract Builder<T> setStorageIntegrationName(String var1);

            abstract Builder<T> setStagingBucketName(String var1);

            abstract Builder<T> setQuery(String var1);

            abstract Builder<T> setFileNameTemplate(String var1);

            abstract Builder<T> setUserDataMapper(UserDataMapper var1);

            abstract Builder<T> setWriteDisposition(WriteDisposition var1);

            abstract Builder<T> setSnowflakeService(SnowflakeService var1);

            abstract Write<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        @Nullable
        abstract String getQuery();

        @Nullable
        abstract String getTable();

        @Nullable
        abstract String getStorageIntegrationName();

        @Nullable
        abstract String getStagingBucketName();

        @Nullable
        abstract CsvMapper<T> getCsvMapper();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract SnowflakeService getSnowflakeService();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(new DataSourceProviderFromDataSourceConfiguration(config));
        }

        public Read<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Read<T> fromQuery(String query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> fromTable(String table) {
            return this.toBuilder().setTable(table).build();
        }

        public Read<T> withStagingBucketName(String stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Read<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Read<T> withCsvMapper(CsvMapper<T> csvMapper) {
            return this.toBuilder().setCsvMapper(csvMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public PCollection<T> expand(PBegin input) {
            this.checkArguments();
            String tmpDirName = this.makeTmpDirName();
            String stagingBucketDir = String.format("%s/%s/", this.getStagingBucketName(), tmpDirName);
            PCollection emptyCollection = (PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]));
            PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)emptyCollection.apply((PTransform)ParDo.of((DoFn)new CopyIntoStageFn(this.getDataSourceProviderFn(), this.getQuery(), this.getTable(), this.getStorageIntegrationName(), stagingBucketDir, this.getSnowflakeService())))).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)TextIO.readFiles())).apply((PTransform)ParDo.of((DoFn)new MapCsvToStringArrayFn()))).apply((PTransform)ParDo.of(new MapStringArrayToUserDataFn<T>(this.getCsvMapper())));
            output.setCoder(this.getCoder());
            ((PCollection)emptyCollection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{output}))).apply((PTransform)ParDo.of((DoFn)new CleanTmpFilesFromGcsFn(stagingBucketDir)));
            return output;
        }

        private void checkArguments() {
            Preconditions.checkArgument((this.getStorageIntegrationName() != null ? 1 : 0) != 0, (Object)"withStorageIntegrationName is required");
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName is required");
            Preconditions.checkArgument((this.getQuery() != null || this.getTable() != null ? 1 : 0) != 0, (Object)"fromTable() or fromQuery() is required");
            Preconditions.checkArgument((this.getQuery() == null || this.getTable() == null ? 1 : 0) != 0, (Object)"fromTable() and fromQuery() are not allowed together");
            Preconditions.checkArgument((this.getCsvMapper() != null ? 1 : 0) != 0, (Object)"withCsvMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
        }

        private String makeTmpDirName() {
            return String.format("sf_copy_csv_%s_%s", new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()), UUID.randomUUID().toString().subSequence(0, 8));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.getQuery() != null) {
                builder.add(DisplayData.item((String)"query", (String)this.getQuery()));
            }
            if (this.getTable() != null) {
                builder.add(DisplayData.item((String)"table", (String)this.getTable()));
            }
            builder.add(DisplayData.item((String)"storageIntegrationName", (String)this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"stagingBucketName", (String)this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"csvMapper", (String)this.getCsvMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        public static class CleanTmpFilesFromGcsFn
        extends DoFn<Object, Object> {
            private final String stagingBucketDir;

            public CleanTmpFilesFromGcsFn(String stagingBucketDir) {
                this.stagingBucketDir = stagingBucketDir;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String combinedPath = this.stagingBucketDir + "/**";
                List paths = FileSystems.match((String)combinedPath).metadata().stream().map(metadata -> metadata.resourceId()).collect(Collectors.toList());
                FileSystems.delete(paths, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
            }
        }

        private static class MapStringArrayToUserDataFn<T>
        extends DoFn<String[], T> {
            private final CsvMapper<T> csvMapper;

            public MapStringArrayToUserDataFn(CsvMapper<T> csvMapper) {
                this.csvMapper = csvMapper;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                context.output(this.csvMapper.mapRow((String[])context.element()));
            }
        }

        public static class MapCsvToStringArrayFn
        extends DoFn<String, String[]> {
            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String csvLine = (String)c.element();
                CSVParser parser = new CSVParserBuilder().withQuoteChar(SnowflakeIO.CSV_QUOTE_CHAR.charAt(0)).build();
                String[] parts = parser.parseLine(csvLine);
                c.output((Object)parts);
            }
        }

        private static class CopyIntoStageFn
        extends DoFn<Object, String> {
            private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
            private final String query;
            private final String table;
            private final String storageIntegrationName;
            private final String stagingBucketDir;
            private final SnowflakeService snowflakeService;

            private CopyIntoStageFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, String query, String table, String storageIntegrationName, String stagingBucketDir, SnowflakeService snowflakeService) {
                this.dataSourceProviderFn = dataSourceProviderFn;
                this.query = query;
                this.table = table;
                this.storageIntegrationName = storageIntegrationName;
                this.stagingBucketDir = String.format("%s/run_%s/", stagingBucketDir, UUID.randomUUID().toString().subSequence(0, 8));
                this.snowflakeService = snowflakeService;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                SnowflakeServiceConfig config = new SnowflakeServiceConfig(this.dataSourceProviderFn, this.table, this.query, this.storageIntegrationName, this.stagingBucketDir);
                String output = this.snowflakeService.read(config);
                context.output((Object)output);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setQuery(String var1);

            abstract Builder<T> setTable(String var1);

            abstract Builder<T> setStorageIntegrationName(String var1);

            abstract Builder<T> setStagingBucketName(String var1);

            abstract Builder<T> setCsvMapper(CsvMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setSnowflakeService(SnowflakeService var1);

            abstract Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface UserDataMapper<T>
    extends Serializable {
        public Object[] mapRow(T var1);
    }

    @FunctionalInterface
    public static interface CsvMapper<T>
    extends Serializable {
        public T mapRow(String[] var1) throws Exception;
    }
}

