/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.redis.AutoValue_RedisConnectionConfiguration;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import redis.clients.jedis.Jedis;

@AutoValue
public abstract class RedisConnectionConfiguration
implements Serializable {
    abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host();

    abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> auth();

    abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout();

    abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> ssl();

    abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

    public static @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration create() {
        return new AutoValue_RedisConnectionConfiguration.Builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"127.0.0.1")).setPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)6379)).setTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)2000)).setSsl((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.FALSE)).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration create(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) {
        return RedisConnectionConfiguration.create().withHost(host).withPort(port);
    }

    public static @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration create(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
        return RedisConnectionConfiguration.create().withHost(host).withPort(port);
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withHost(@UnknownKeyFor @NonNull @Initialized String host) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
        return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
        return this.builder().setHost(host).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withPort(@UnknownKeyFor @NonNull @Initialized int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port can not be negative or 0");
        return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
        return this.builder().setPort(port).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withAuth(@UnknownKeyFor @NonNull @Initialized String auth) {
        Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
        return this.withAuth((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)auth));
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> auth) {
        return this.builder().setAuth(auth).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withTimeout(@UnknownKeyFor @NonNull @Initialized int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
        return this.withTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
        return this.builder().setTimeout(timeout).build();
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration enableSSL() {
        return this.withSSL((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.TRUE));
    }

    public @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration withSSL(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> ssl) {
        return this.builder().setSsl(ssl).build();
    }

    public @UnknownKeyFor @NonNull @Initialized Jedis connect() {
        Jedis jedis = new Jedis((String)this.host().get(), ((Integer)this.port().get()).intValue(), ((Integer)this.timeout().get()).intValue(), ((Boolean)this.ssl().get()).booleanValue());
        if (this.auth() != null) {
            jedis.auth((String)this.auth().get());
        }
        return jedis;
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"host", this.host()));
        builder.add(DisplayData.item((String)"port", this.port()));
        builder.addIfNotNull(DisplayData.item((String)"timeout", this.timeout()));
        builder.add(DisplayData.item((String)"ssl", this.ssl()));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAuth(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setSsl(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration build();
    }
}

