/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.redis.AutoValue_RedisIO_Read;
import org.apache.beam.sdk.io.redis.AutoValue_RedisIO_ReadAll;
import org.apache.beam.sdk.io.redis.AutoValue_RedisIO_ReadKeyPatterns;
import org.apache.beam.sdk.io.redis.AutoValue_RedisIO_Write;
import org.apache.beam.sdk.io.redis.RedisConnectionConfiguration;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class RedisIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_RedisIO_Read.Builder().setConnectionConfiguration(RedisConnectionConfiguration.create()).setKeyPattern("*").setBatchSize(1000).setOutputParallelization(true).build();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized ReadAll readAll() {
        return new AutoValue_RedisIO_ReadAll.Builder().setConnectionConfiguration(RedisConnectionConfiguration.create()).setBatchSize(1000).setOutputParallelization(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns readKeyPatterns() {
        return new AutoValue_RedisIO_ReadKeyPatterns.Builder().setConnectionConfiguration(RedisConnectionConfiguration.create()).setBatchSize(1000).setOutputParallelization(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_RedisIO_Write.Builder().setConnectionConfiguration(RedisConnectionConfiguration.create()).setMethod(Write.Method.APPEND).build();
    }

    private RedisIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<KV<String, String>>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized RedisConnectionConfiguration connectionConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized Method method();

        abstract @Nullable @UnknownKeyFor @Initialized Long expireTime();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write withEndpoint(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port can not be negative or 0");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withHost(host).withPort(port)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAuth(@UnknownKeyFor @NonNull @Initialized String auth) {
            Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withAuth(auth)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTimeout(@UnknownKeyFor @NonNull @Initialized int timeout) {
            Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withTimeout(timeout)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connection) {
            Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"connection can not be null");
            return this.toBuilder().setConnectionConfiguration(connection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
            Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"method can not be null");
            return this.toBuilder().setMethod(method).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withExpireTime(@UnknownKeyFor @NonNull @Initialized Long expireTimeMillis) {
            Preconditions.checkArgument((expireTimeMillis != null ? 1 : 0) != 0, (Object)"expireTimeMillis can not be null");
            Preconditions.checkArgument((expireTimeMillis > 0L ? 1 : 0) != 0, (Object)"expireTimeMillis can not be negative or 0");
            return this.toBuilder().setExpireTime(expireTimeMillis).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> input) {
            Preconditions.checkArgument((this.connectionConfiguration() != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriteFn
        extends DoFn<KV<String, String>, Void> {
            private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BATCH_SIZE = 1000;
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private transient @UnknownKeyFor @NonNull @Initialized Jedis jedis;
            private transient @UnknownKeyFor @NonNull @Initialized redis.clients.jedis.Pipeline pipeline;
            private @UnknownKeyFor @NonNull @Initialized int batchCount;

            public WriteFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() {
                this.jedis = this.spec.connectionConfiguration().connect();
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.pipeline = this.jedis.pipelined();
                this.pipeline.multi();
                this.batchCount = 0;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                KV record = (KV)c.element();
                this.writeRecord((KV<String, String>)record);
                ++this.batchCount;
                if (this.batchCount >= 1000) {
                    this.pipeline.exec();
                    this.pipeline.sync();
                    this.pipeline.multi();
                    this.batchCount = 0;
                }
            }

            private void writeRecord(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record) {
                Method method = this.spec.method();
                Long expireTime = this.spec.expireTime();
                if (Method.APPEND == method) {
                    this.writeUsingAppendCommand(record, expireTime);
                } else if (Method.SET == method) {
                    this.writeUsingSetCommand(record, expireTime);
                } else if (Method.LPUSH == method || Method.RPUSH == method) {
                    this.writeUsingListCommand(record, method, expireTime);
                } else if (Method.SADD == method) {
                    this.writeUsingSaddCommand(record, expireTime);
                } else if (Method.PFADD == method) {
                    this.writeUsingHLLCommand(record, expireTime);
                } else if (Method.INCRBY == method) {
                    this.writeUsingIncrBy(record);
                } else if (Method.DECRBY == method) {
                    this.writeUsingDecrBy(record);
                }
            }

            private void writeUsingAppendCommand(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                this.pipeline.append(key, value);
                this.setExpireTimeWhenRequired(key, expireTime);
            }

            private void writeUsingSetCommand(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                if (expireTime != null) {
                    this.pipeline.psetex(key, expireTime.longValue(), value);
                } else {
                    this.pipeline.set(key, value);
                }
            }

            private void writeUsingListCommand(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record, @UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                if (Method.LPUSH == method) {
                    this.pipeline.lpush(key, new String[]{value});
                } else if (Method.RPUSH == method) {
                    this.pipeline.rpush(key, new String[]{value});
                }
                this.setExpireTimeWhenRequired(key, expireTime);
            }

            private void writeUsingSaddCommand(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                this.pipeline.sadd(key, new String[]{value});
            }

            private void writeUsingHLLCommand(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                this.pipeline.pfadd(key, new String[]{value});
            }

            private void writeUsingIncrBy(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                long inc = Long.parseLong(value);
                this.pipeline.incrBy(key, inc);
            }

            private void writeUsingDecrBy(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> record) {
                String key = (String)record.getKey();
                String value = (String)record.getValue();
                long decr = Long.parseLong(value);
                this.pipeline.decrBy(key, decr);
            }

            private void setExpireTimeWhenRequired(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Long expireTime) {
                if (expireTime != null) {
                    this.pipeline.pexpire(key, expireTime.longValue());
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() {
                if (this.pipeline.isInMulti()) {
                    this.pipeline.exec();
                    this.pipeline.sync();
                }
                this.batchCount = 0;
            }

            @DoFn.Teardown
            public void teardown() {
                this.jedis.close();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMethod(@UnknownKeyFor @NonNull @Initialized Method var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExpireTime(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }

        public static enum Method {
            APPEND,
            SET,
            LPUSH,
            RPUSH,
            SADD,
            PFADD,
            INCRBY,
            DECRBY;

        }
    }

    private static class Reparallelize
    extends PTransform<PCollection<KV<String, String>>, PCollection<KV<String, String>>> {
        private Reparallelize() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> input) {
            PCollectionView empty = (PCollectionView)((PCollection)input.apply("Consume", (PTransform)Filter.by((SerializableFunction)SerializableFunctions.constant((Object)false)))).apply((PTransform)View.asIterable());
            PCollection materialized = (PCollection)input.apply("Identity", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, String>, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output((Object)((KV)c.element()));
                }
            }).withSideInputs(new PCollectionView[]{empty}));
            return (PCollection)materialized.apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    private static class ReadFn
    extends BaseReadFn<KV<String, String>> {
        transient @Nullable @UnknownKeyFor @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized String> bundles = null;
        @Nullable @UnknownKeyFor @Initialized AtomicInteger batchCount = null;
        private final @UnknownKeyFor @NonNull @Initialized int batchSize;

        ReadFn(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connectionConfiguration, @UnknownKeyFor @NonNull @Initialized int batchSize) {
            super(connectionConfiguration);
            this.batchSize = batchSize;
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.bundles = ArrayListMultimap.create();
            this.batchCount = new AtomicInteger();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            String key = (String)c.element();
            this.bundles.put((Object)window, (Object)key);
            if (this.batchCount.incrementAndGet() > this.getBatchSize()) {
                Multimap<BoundedWindow, KV<String, String>> kvs = this.fetchAndFlush();
                for (BoundedWindow w : kvs.keySet()) {
                    for (KV kv : kvs.get((Object)w)) {
                        c.output((Object)kv);
                    }
                }
            }
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) {
            Multimap<BoundedWindow, KV<String, String>> kvs = this.fetchAndFlush();
            for (BoundedWindow w : kvs.keySet()) {
                for (KV kv : kvs.get((Object)w)) {
                    context.output((Object)kv, w.maxTimestamp(), w);
                }
            }
        }

        private @UnknownKeyFor @NonNull @Initialized int getBatchSize() {
            return this.batchSize;
        }

        private @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> fetchAndFlush() {
            ArrayListMultimap kvs = ArrayListMultimap.create();
            for (BoundedWindow w : this.bundles.keySet()) {
                String[] keys = new String[this.bundles.get((Object)w).size()];
                this.bundles.get((Object)w).toArray(keys);
                List results = this.jedis.mget(keys);
                for (int i = 0; i < results.size(); ++i) {
                    if (results.get(i) == null) continue;
                    kvs.put((Object)w, (Object)KV.of((Object)keys[i], (Object)((String)results.get(i))));
                }
            }
            this.bundles = ArrayListMultimap.create();
            this.batchCount.set(0);
            return kvs;
        }
    }

    private static class ReadKeysWithPattern
    extends BaseReadFn<String> {
        ReadKeysWithPattern(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connectionConfiguration) {
            super(connectionConfiguration);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            ScanParams scanParams = new ScanParams();
            scanParams.match((String)c.element());
            String cursor = ScanParams.SCAN_POINTER_START;
            boolean finished = false;
            while (!finished) {
                ScanResult scanResult = this.jedis.scan(cursor, scanParams);
                List keys = scanResult.getResult();
                for (String k : keys) {
                    c.output((Object)k);
                }
                cursor = scanResult.getCursor();
                if (!cursor.equals(ScanParams.SCAN_POINTER_START)) continue;
                finished = true;
            }
        }
    }

    private static abstract class BaseReadFn<@UnknownKeyFor T>
    extends DoFn<String, T> {
        protected final @UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connectionConfiguration;
        transient @UnknownKeyFor @NonNull @Initialized Jedis jedis;

        BaseReadFn(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
        }

        @DoFn.Setup
        public void setup() {
            this.jedis = this.connectionConfiguration.connect();
        }

        @DoFn.Teardown
        public void teardown() {
            this.jedis.close();
        }
    }

    @AutoValue
    public static abstract class ReadKeyPatterns
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        abstract @Nullable @UnknownKeyFor @Initialized RedisConnectionConfiguration connectionConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized int batchSize();

        abstract @UnknownKeyFor @NonNull @Initialized boolean outputParallelization();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withEndpoint(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port can not be negative or 0");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withHost(host).withPort(port)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withAuth(@UnknownKeyFor @NonNull @Initialized String auth) {
            Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withAuth(auth)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withTimeout(@UnknownKeyFor @NonNull @Initialized int timeout) {
            Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withTimeout(timeout)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connection) {
            Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"connection can not be null");
            return this.toBuilder().setConnectionConfiguration(connection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns withOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkArgument((this.connectionConfiguration() != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            PCollection output = ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ReadFn(this.connectionConfiguration(), this.batchSize())))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
            if (this.outputParallelization()) {
                output = (PCollection)output.apply((PTransform)new Reparallelize());
            }
            return output;
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @Nullable @UnknownKeyFor @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadKeyPatterns build();
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        abstract @Nullable @UnknownKeyFor @Initialized RedisConnectionConfiguration connectionConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized int batchSize();

        abstract @UnknownKeyFor @NonNull @Initialized boolean outputParallelization();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll withEndpoint(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port can not be negative or 0");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withHost(host).withPort(port)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withAuth(@UnknownKeyFor @NonNull @Initialized String auth) {
            Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withAuth(auth)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTimeout(@UnknownKeyFor @NonNull @Initialized int timeout) {
            Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withTimeout(timeout)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connection) {
            Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"connection can not be null");
            return this.toBuilder().setConnectionConfiguration(connection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkArgument((this.connectionConfiguration() != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            PCollection output = ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ReadFn(this.connectionConfiguration(), this.batchSize())))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of()));
            if (this.outputParallelization()) {
                output = (PCollection)output.apply((PTransform)new Reparallelize());
            }
            return output;
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @Nullable @UnknownKeyFor @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<KV<String, String>>> {
        abstract @Nullable @UnknownKeyFor @Initialized RedisConnectionConfiguration connectionConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized String keyPattern();

        abstract @UnknownKeyFor @NonNull @Initialized int batchSize();

        abstract @UnknownKeyFor @NonNull @Initialized boolean outputParallelization();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withEndpoint(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can not be null");
            Preconditions.checkArgument((0 < port && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer less than 65536");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withHost(host).withPort(port)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAuth(@UnknownKeyFor @NonNull @Initialized String auth) {
            Preconditions.checkArgument((auth != null ? 1 : 0) != 0, (Object)"auth can not be null");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withAuth(auth)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTimeout(@UnknownKeyFor @NonNull @Initialized int timeout) {
            Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout can not be negative");
            return this.toBuilder().setConnectionConfiguration(this.connectionConfiguration().withTimeout(timeout)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyPattern(@UnknownKeyFor @NonNull @Initialized String keyPattern) {
            Preconditions.checkArgument((keyPattern != null ? 1 : 0) != 0, (Object)"keyPattern can not be null");
            return this.toBuilder().setKeyPattern(keyPattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration connection) {
            Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"connection can not be null");
            return this.toBuilder().setConnectionConfiguration(connection).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean outputParallelization) {
            return this.toBuilder().setOutputParallelization(outputParallelization).build();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.connectionConfiguration().populateDisplayData(builder);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.connectionConfiguration() != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.keyPattern(), (Object[])new String[0]))).apply((PTransform)ParDo.of((DoFn)new ReadKeysWithPattern(this.connectionConfiguration())))).apply((PTransform)RedisIO.readKeyPatterns().withConnectionConfiguration(this.connectionConfiguration()).withBatchSize(this.batchSize()).withOutputParallelization(this.outputParallelization()));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @Nullable @UnknownKeyFor @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized RedisConnectionConfiguration var1);

            abstract @Nullable @UnknownKeyFor @Initialized Builder setKeyPattern(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputParallelization(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

