/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.redis;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.redis.RedisConnectionConfiguration;

final class AutoValue_RedisConnectionConfiguration
extends RedisConnectionConfiguration {
    private final String host;
    private final int port;
    private final String auth;
    private final int timeout;

    private AutoValue_RedisConnectionConfiguration(String host, int port, @Nullable String auth, int timeout) {
        this.host = host;
        this.port = port;
        this.auth = auth;
        this.timeout = timeout;
    }

    @Override
    String host() {
        return this.host;
    }

    @Override
    int port() {
        return this.port;
    }

    @Override
    @Nullable
    String auth() {
        return this.auth;
    }

    @Override
    int timeout() {
        return this.timeout;
    }

    public String toString() {
        return "RedisConnectionConfiguration{host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", timeout=" + this.timeout + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisConnectionConfiguration) {
            RedisConnectionConfiguration that = (RedisConnectionConfiguration)o;
            return this.host.equals(that.host()) && this.port == that.port() && (this.auth == null ? that.auth() == null : this.auth.equals(that.auth())) && this.timeout == that.timeout();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.host.hashCode();
        h$ *= 1000003;
        h$ ^= this.port;
        h$ *= 1000003;
        h$ ^= this.auth == null ? 0 : this.auth.hashCode();
        h$ *= 1000003;
        return h$ ^= this.timeout;
    }

    @Override
    RedisConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends RedisConnectionConfiguration.Builder {
        private String host;
        private Integer port;
        private String auth;
        private Integer timeout;

        Builder() {
        }

        private Builder(RedisConnectionConfiguration source) {
            this.host = source.host();
            this.port = source.port();
            this.auth = source.auth();
            this.timeout = source.timeout();
        }

        @Override
        RedisConnectionConfiguration.Builder setHost(String host) {
            if (host == null) {
                throw new NullPointerException("Null host");
            }
            this.host = host;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setPort(int port) {
            this.port = port;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setAuth(String auth) {
            this.auth = auth;
            return this;
        }

        @Override
        RedisConnectionConfiguration.Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        RedisConnectionConfiguration build() {
            String missing = "";
            if (this.host == null) {
                missing = missing + " host";
            }
            if (this.port == null) {
                missing = missing + " port";
            }
            if (this.timeout == null) {
                missing = missing + " timeout";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RedisConnectionConfiguration(this.host, this.port, this.auth, this.timeout);
        }
    }
}

