/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Parse;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ParseFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Read;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Sink;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ParquetIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_ParquetIO_Read.Builder().setSchema(schema).setInferBeamSchema(false).setSplittable(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles readFiles(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_ParquetIO_ReadFiles.Builder().setSplittable(false).setInferBeamSchema(false).setSchema(schema).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Parse<T> parseGenericRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn) {
        return new AutoValue_ParquetIO_Parse.Builder<T>().setParseFn(parseFn).setSplittable(false).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ParseFiles<T> parseFilesGenericRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn) {
        return new AutoValue_ParquetIO_ParseFiles.Builder<T>().setParseFn(parseFn).setSplittable(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Sink sink(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_ParquetIO_Sink.Builder().setJsonSchema(schema.toString()).setCompressionCodec(CompressionCodecName.SNAPPY).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized GenericData buildModelObject(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GenericData> modelClass) throws @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
        return modelClass == null ? null : (GenericData)modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
    }

    private ParquetIO() {
    }

    @VisibleForTesting
    static final class GenericRecordPassthroughFn
    implements SerializableFunction<GenericRecord, GenericRecord> {
        private static final @UnknownKeyFor @NonNull @Initialized GenericRecordPassthroughFn singleton = new GenericRecordPassthroughFn();

        static @UnknownKeyFor @NonNull @Initialized GenericRecordPassthroughFn create() {
            return singleton;
        }

        public @UnknownKeyFor @NonNull @Initialized GenericRecord apply(@UnknownKeyFor @NonNull @Initialized GenericRecord input) {
            return input;
        }

        private GenericRecordPassthroughFn() {
        }
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<GenericRecord> {
        @Nullable
        private transient @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ParquetWriter<@UnknownKeyFor @NonNull @Initialized GenericRecord> writer;

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getJsonSchema();

        abstract @UnknownKeyFor @NonNull @Initialized CompressionCodecName getCompressionCodec();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Sink withCompressionCodec(@UnknownKeyFor @NonNull @Initialized CompressionCodecName compressionCodecName) {
            return this.toBuilder().setCompressionCodec(compressionCodecName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Sink withConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configuration) {
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkNotNull((Object)this.getJsonSchema(), (String)"Schema cannot be null");
            Schema schema = new Schema.Parser().parse(this.getJsonSchema());
            BeamParquetOutputFile beamParquetOutputFile = new BeamParquetOutputFile(Channels.newOutputStream(channel));
            this.writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)beamParquetOutputFile).withSchema(schema).withCompressionCodec(this.getCompressionCodec())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withConf(SerializableConfiguration.newConfiguration((SerializableConfiguration)this.getConfiguration()))).build();
        }

        public void write(@UnknownKeyFor @NonNull @Initialized GenericRecord element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkNotNull(this.writer, (String)"Writer cannot be null");
            this.writer.write((Object)element);
        }

        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.close();
        }

        private static class BeamOutputStream
        extends PositionOutputStream {
            private @UnknownKeyFor @NonNull @Initialized long position = 0L;
            private final @UnknownKeyFor @NonNull @Initialized OutputStream outputStream;

            private BeamOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public @UnknownKeyFor @NonNull @Initialized long getPos() {
                return this.position;
            }

            public void write(@UnknownKeyFor @NonNull @Initialized int b) throws @UnknownKeyFor @NonNull @Initialized IOException {
                ++this.position;
                this.outputStream.write(b);
            }

            public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.write(b, 0, b.length);
            }

            public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.outputStream.write(b, off, len);
                this.position += (long)len;
            }

            public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.outputStream.flush();
            }

            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.outputStream.close();
            }
        }

        private static class BeamParquetOutputFile
        implements OutputFile {
            private final @UnknownKeyFor @NonNull @Initialized OutputStream outputStream;

            BeamParquetOutputFile(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public @UnknownKeyFor @NonNull @Initialized PositionOutputStream create(@UnknownKeyFor @NonNull @Initialized long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public @UnknownKeyFor @NonNull @Initialized PositionOutputStream createOrOverwrite(@UnknownKeyFor @NonNull @Initialized long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public @UnknownKeyFor @NonNull @Initialized boolean supportsBlockSize() {
                return false;
            }

            public @UnknownKeyFor @NonNull @Initialized long defaultBlockSize() {
                return 0L;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompressionCodec(@UnknownKeyFor @NonNull @Initialized CompressionCodecName var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Sink build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<GenericRecord>> {
        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized GenericData getAvroDataModel();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getEncoderSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getProjectionSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getInferBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isSplittable();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withAvroDataModel(@UnknownKeyFor @NonNull @Initialized GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withProjection(@UnknownKeyFor @NonNull @Initialized Schema projectionSchema, @UnknownKeyFor @NonNull @Initialized Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setEncoderSchema(encoderSchema).setSplittable(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configuration) {
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public @UnknownKeyFor @NonNull @Initialized ReadFiles withBeamSchemas(@UnknownKeyFor @NonNull @Initialized boolean inferBeamSchema) {
            return this.toBuilder().setInferBeamSchema(inferBeamSchema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GenericRecord> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            Preconditions.checkNotNull((Object)this.getSchema(), (String)"Schema can not be null");
            return ((PCollection)input.apply((PTransform)ParDo.of(this.getReaderFn()))).setCoder(this.getCollectionCoder());
        }

        private @UnknownKeyFor @NonNull @Initialized DoFn<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile, @UnknownKeyFor @NonNull @Initialized GenericRecord> getReaderFn() {
            return this.isSplittable() ? new SplitReadFn<GenericRecord>(this.getAvroDataModel(), this.getProjectionSchema(), GenericRecordPassthroughFn.create(), this.getConfiguration()) : new ReadFn<GenericRecord>(this.getAvroDataModel(), GenericRecordPassthroughFn.create(), this.getConfiguration());
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        private @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized GenericRecord> getCollectionCoder() {
            Schema coderSchema = this.getProjectionSchema() != null && this.isSplittable() ? this.getEncoderSchema() : this.getSchema();
            return this.getInferBeamSchema() ? AvroUtils.schemaCoder((Schema)coderSchema) : AvroCoder.of((Schema)coderSchema);
        }

        private static class BeamParquetInputFile
        implements InputFile {
            private final @UnknownKeyFor @NonNull @Initialized SeekableByteChannel seekableByteChannel;

            BeamParquetInputFile(@UnknownKeyFor @NonNull @Initialized SeekableByteChannel seekableByteChannel) {
                this.seekableByteChannel = seekableByteChannel;
            }

            public @UnknownKeyFor @NonNull @Initialized long getLength() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.seekableByteChannel.size();
            }

            public @UnknownKeyFor @NonNull @Initialized SeekableInputStream newStream() {
                return new DelegatingSeekableInputStream(Channels.newInputStream(this.seekableByteChannel)){

                    public @UnknownKeyFor @NonNull @Initialized long getPos() throws @UnknownKeyFor @NonNull @Initialized IOException {
                        return seekableByteChannel.position();
                    }

                    public void seek(@UnknownKeyFor @NonNull @Initialized long newPos) throws @UnknownKeyFor @NonNull @Initialized IOException {
                        seekableByteChannel.position(newPos);
                    }
                };
            }
        }

        static class ReadFn<@UnknownKeyFor T>
        extends DoFn<FileIO.ReadableFile, T> {
            private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GenericData> modelClass;
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn;
            private final @UnknownKeyFor @NonNull @Initialized SerializableConfiguration configuration;

            ReadFn(@UnknownKeyFor @NonNull @Initialized GenericData model, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized SerializableConfiguration configuration) {
                this.modelClass = model != null ? model.getClass() : null;
                this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (String)"GenericRecord parse function is null");
                this.configuration = configuration;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) throws @UnknownKeyFor @NonNull @Initialized Exception {
                FileIO.ReadableFile file = (FileIO.ReadableFile)processContext.element();
                if (!file.getMetadata().isReadSeekEfficient()) {
                    ResourceId filename = file.getMetadata().resourceId();
                    throw new RuntimeException(String.format("File has to be seekable: %s", filename));
                }
                SeekableByteChannel seekableByteChannel = file.openSeekable();
                AvroParquetReader.Builder builder = (AvroParquetReader.Builder)AvroParquetReader.builder((InputFile)new BeamParquetInputFile(seekableByteChannel)).withConf(SerializableConfiguration.newConfiguration((SerializableConfiguration)this.configuration));
                if (this.modelClass != null) {
                    builder = builder.withDataModel(ParquetIO.buildModelObject(this.modelClass));
                }
                try (ParquetReader reader = builder.build();){
                    GenericRecord read;
                    while ((read = (GenericRecord)reader.read()) != null) {
                        processContext.output(this.parseFn.apply((Object)read));
                    }
                }
            }
        }

        public static class BlockTracker
        extends OffsetRangeTracker {
            private @UnknownKeyFor @NonNull @Initialized long totalWork;
            private @UnknownKeyFor @NonNull @Initialized long progress;
            private @UnknownKeyFor @NonNull @Initialized long approximateRecordSize;

            public BlockTracker(@UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized long totalByteSize, @UnknownKeyFor @NonNull @Initialized long recordCount) {
                super(range);
                if (recordCount != 0L) {
                    this.approximateRecordSize = totalByteSize / recordCount;
                    this.totalWork = this.approximateRecordSize * recordCount;
                    this.progress = 0L;
                }
            }

            public void makeProgress() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.progress += this.approximateRecordSize;
                if (this.progress > this.totalWork) {
                    throw new IOException("Making progress out of range");
                }
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
                return super.getProgress();
            }
        }

        @DoFn.BoundedPerElement
        static class SplitReadFn<@UnknownKeyFor T>
        extends DoFn<FileIO.ReadableFile, T> {
            private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GenericData> modelClass;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplitReadFn.class);
            private final @UnknownKeyFor @NonNull @Initialized String requestSchemaString;
            private static final @UnknownKeyFor @NonNull @Initialized long SPLIT_LIMIT = 64000000L;
            @Nullable
            private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration configuration;
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn;

            SplitReadFn(@UnknownKeyFor @NonNull @Initialized GenericData model, @UnknownKeyFor @NonNull @Initialized Schema requestSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration configuration) {
                this.modelClass = model != null ? model.getClass() : null;
                this.requestSchemaString = requestSchema != null ? requestSchema.toString() : null;
                this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (String)"GenericRecord parse function can't be null");
                this.configuration = configuration;
            }

            @UnknownKeyFor @NonNull @Initialized ParquetFileReader getParquetFileReader(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)this.getConfWithModelClass()).build();
                return ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> outputReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                LOG.debug("start " + ((OffsetRange)tracker.currentRestriction()).getFrom() + " to " + ((OffsetRange)tracker.currentRestriction()).getTo());
                Configuration conf = this.getConfWithModelClass();
                GenericData model = null;
                if (this.modelClass != null) {
                    model = (GenericData)this.modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                }
                AvroReadSupport readSupport = new AvroReadSupport(model);
                if (this.requestSchemaString != null) {
                    AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)new Schema.Parser().parse(this.requestSchemaString));
                }
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)conf).build();
                ParquetFileReader reader = ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);
                FilterCompat.Filter filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)options.getRecordFilter(), (String)"filter");
                Configuration hadoopConf = ((HadoopReadOptions)options).getConf();
                FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
                MessageType fileSchema = parquetFileMetadata.getSchema();
                Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
                ReadSupport.ReadContext readContext = readSupport.init(new InitContext(hadoopConf, Maps.transformValues((Map)fileMetadata, ImmutableSet::of), fileSchema));
                ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
                RecordMaterializer recordConverter = readSupport.prepareForRead(hadoopConf, fileMetadata, fileSchema, readContext);
                reader.setRequestedSchema(readContext.getRequestedSchema());
                MessageColumnIO columnIO = columnIOFactory.getColumnIO(readContext.getRequestedSchema(), fileSchema, true);
                long currentBlock = ((OffsetRange)tracker.currentRestriction()).getFrom();
                int i = 0;
                while ((long)i < currentBlock) {
                    reader.skipNextRowGroup();
                    ++i;
                }
                while (tracker.tryClaim((Object)currentBlock)) {
                    long currentRow;
                    PageReadStore pages = reader.readNextRowGroup();
                    LOG.debug("block {} read in memory. row count = {}", (Object)currentBlock, (Object)pages.getRowCount());
                    ++currentBlock;
                    RecordReader recordReader = columnIO.getRecordReader(pages, recordConverter, options.useRecordFilter() ? filter : FilterCompat.NOOP);
                    long totalRows = pages.getRowCount();
                    for (currentRow = 0L; currentRow < totalRows; ++currentRow) {
                        try {
                            GenericRecord record;
                            try {
                                record = (GenericRecord)recordReader.read();
                            }
                            catch (RecordMaterializer.RecordMaterializationException e) {
                                LOG.warn("skipping a corrupt record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                continue;
                            }
                            if (record == null) {
                                LOG.debug("filtered record reader reached end of block in block {} in file {}", (Object)currentBlock, (Object)file.toString());
                                break;
                            }
                            if (recordReader.shouldSkipCurrentRecord()) {
                                LOG.debug("skipping record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                continue;
                            }
                            outputReceiver.output(this.parseFn.apply((Object)record));
                            continue;
                        }
                        catch (RuntimeException e) {
                            throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", currentRow, currentBlock, file.toString()), (Throwable)e);
                        }
                    }
                    LOG.debug("Finish processing {} rows from block {} in file {}", new Object[]{currentRow, currentBlock - 1L, file.toString()});
                }
            }

            public @UnknownKeyFor @NonNull @Initialized Configuration getConfWithModelClass() throws @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
                Configuration conf = SerializableConfiguration.newConfiguration((SerializableConfiguration)this.configuration);
                GenericData model = ParquetIO.buildModelObject(this.modelClass);
                if (model != null && (model.getClass() == GenericData.class || model.getClass() == SpecificData.class)) {
                    conf.setBoolean("parquet.avro.compatible", true);
                } else {
                    conf.setBoolean("parquet.avro.compatible", false);
                }
                return conf;
            }

            @DoFn.GetInitialRestriction
            public @UnknownKeyFor @NonNull @Initialized OffsetRange getInitialRestriction(@DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                return new OffsetRange(0L, (long)reader.getRowGroups().size());
            }

            @DoFn.SplitRestriction
            public void split(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized OffsetRange> out, @DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                List rowGroups = reader.getRowGroups();
                for (OffsetRange offsetRange : this.splitBlockWithLimit(restriction.getFrom(), restriction.getTo(), rowGroups, 64000000L)) {
                    out.output((Object)offsetRange);
                }
            }

            public @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized OffsetRange> splitBlockWithLimit(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BlockMetaData> blockList, @UnknownKeyFor @NonNull @Initialized long limit) {
                ArrayList<OffsetRange> offsetList = new ArrayList<OffsetRange>();
                long totalSize = 0L;
                long rangeStart = start;
                for (long rangeEnd = start; rangeEnd < end; ++rangeEnd) {
                    if ((totalSize += blockList.get((int)rangeEnd).getTotalByteSize()) < limit) continue;
                    offsetList.add(new OffsetRange(rangeStart, rangeEnd + 1L));
                    rangeStart = rangeEnd + 1L;
                    totalSize = 0L;
                }
                if (totalSize != 0L) {
                    offsetList.add(new OffsetRange(rangeStart, end));
                }
                return offsetList;
            }

            @DoFn.NewTracker
            public @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction, @DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file) throws @UnknownKeyFor @NonNull @Initialized Exception {
                CountAndSize recordCountAndSize = this.getRecordCountAndSize(file, restriction);
                return new BlockTracker(restriction, Math.round(recordCountAndSize.getSize()), Math.round(recordCountAndSize.getCount()));
            }

            @DoFn.GetRestrictionCoder
            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized OffsetRange.Coder getRestrictionCoder() {
                return new OffsetRange.Coder();
            }

            @DoFn.GetSize
            public @UnknownKeyFor @NonNull @Initialized double getSize(@DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction) throws @UnknownKeyFor @NonNull @Initialized Exception {
                return this.getRecordCountAndSize(file, restriction).getSize();
            }

            private @UnknownKeyFor @NonNull @Initialized CountAndSize getRecordCountAndSize(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized OffsetRange restriction) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                double size = 0.0;
                double recordCount = 0.0;
                for (long i = restriction.getFrom(); i < restriction.getTo(); ++i) {
                    BlockMetaData block = (BlockMetaData)reader.getRowGroups().get((int)i);
                    recordCount += (double)block.getRowCount();
                    size += (double)block.getTotalByteSize();
                }
                return CountAndSize.create(recordCount, size);
            }

            @AutoValue
            static abstract class CountAndSize {
                CountAndSize() {
                }

                static @UnknownKeyFor @NonNull @Initialized CountAndSize create(@UnknownKeyFor @NonNull @Initialized double count, @UnknownKeyFor @NonNull @Initialized double size) {
                    return new AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize(count, size);
                }

                abstract @UnknownKeyFor @NonNull @Initialized double getCount();

                abstract @UnknownKeyFor @NonNull @Initialized double getSize();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAvroDataModel(@UnknownKeyFor @NonNull @Initialized GenericData var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEncoderSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectionSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInferBeamSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSplittable(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class ParseFiles<@UnknownKeyFor T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> getParseFn();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isSplittable();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configuration) {
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            Preconditions.checkArgument((!this.isGenericRecordOutput() ? 1 : 0) != 0, (String)"Parse can't be used for reading as GenericRecord.");
            return ((PCollection)input.apply((PTransform)ParDo.of(this.buildFileReadingFn()))).setCoder(this.inferCoder(input.getPipeline().getCoderRegistry()));
        }

        private @UnknownKeyFor @NonNull @Initialized DoFn<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile, T> buildFileReadingFn() {
            return this.isSplittable() ? new ReadFiles.SplitReadFn<T>(null, null, this.getParseFn(), this.getConfiguration()) : new ReadFiles.ReadFn<T>(null, this.getParseFn(), this.getConfiguration());
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isGenericRecordOutput() {
            String outputType = TypeDescriptors.outputOf(this.getParseFn()).getType().getTypeName();
            return outputType.equals(GenericRecord.class.getTypeName());
        }

        private @UnknownKeyFor @NonNull @Initialized Coder<T> inferCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
            if (this.isGenericRecordOutput()) {
                throw new IllegalArgumentException("Parse can't be used for reading as GenericRecord.");
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(this.getParseFn()));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSplittable(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ParseFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Parse<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> getParseFn();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isSplittable();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Parse<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> inputFiles) {
            return this.toBuilder().setFilepattern(inputFiles).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> from(@UnknownKeyFor @NonNull @Initialized String inputFiles) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)inputFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configuration) {
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (String)"Filepattern cannot be null.");
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply(ParquetIO.parseFilesGenericRecords(this.getParseFn()).toBuilder().setSplittable(this.isSplittable()).build());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSplittable(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Parse<T> build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<GenericRecord>> {
        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getProjectionSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Schema getEncoderSchema();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized GenericData getAvroDataModel();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getInferBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isSplittable();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjection(@UnknownKeyFor @NonNull @Initialized Schema projectionSchema, @UnknownKeyFor @NonNull @Initialized Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setSplittable(true).setEncoderSchema(encoderSchema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configuration) {
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public @UnknownKeyFor @NonNull @Initialized Read withBeamSchemas(@UnknownKeyFor @NonNull @Initialized boolean inferBeamSchema) {
            return this.toBuilder().setInferBeamSchema(inferBeamSchema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAvroDataModel(@UnknownKeyFor @NonNull @Initialized GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized GenericRecord> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (String)"Filepattern cannot be null.");
            PCollection inputFiles = (PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches());
            if (this.isSplittable()) {
                return (PCollection)inputFiles.apply((PTransform)ParquetIO.readFiles(this.getSchema()).withSplit().withBeamSchemas(this.getInferBeamSchema()).withAvroDataModel(this.getAvroDataModel()).withProjection(this.getProjectionSchema(), this.getEncoderSchema()));
            }
            return (PCollection)inputFiles.apply((PTransform)ParquetIO.readFiles(this.getSchema()).withBeamSchemas(this.getInferBeamSchema()).withAvroDataModel(this.getAvroDataModel()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInferBeamSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSplittable(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEncoderSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectionSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAvroDataModel(@UnknownKeyFor @NonNull @Initialized GenericData var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

