/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Read;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Sink;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ParquetIO {
    public static Read read(Schema schema) {
        return new AutoValue_ParquetIO_Read.Builder().setSchema(schema).setSplittable(false).build();
    }

    public static ReadFiles readFiles(Schema schema) {
        return new AutoValue_ParquetIO_ReadFiles.Builder().setSchema(schema).setSplittable(false).build();
    }

    public static Sink sink(Schema schema) {
        return new AutoValue_ParquetIO_Sink.Builder().setJsonSchema(schema.toString()).setCompressionCodec(CompressionCodecName.SNAPPY).build();
    }

    private ParquetIO() {
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<GenericRecord> {
        @Nullable
        private transient ParquetWriter<GenericRecord> writer;

        @Nullable
        abstract String getJsonSchema();

        abstract CompressionCodecName getCompressionCodec();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract Builder toBuilder();

        public Sink withCompressionCodec(CompressionCodecName compressionCodecName) {
            return this.toBuilder().setCompressionCodec(compressionCodecName).build();
        }

        public Sink withConfiguration(Map<String, String> configuration) {
            Configuration hadoopConfiguration = new Configuration();
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                hadoopConfiguration.set(entry.getKey(), entry.getValue());
            }
            return this.toBuilder().setConfiguration(new SerializableConfiguration(hadoopConfiguration)).build();
        }

        public void open(WritableByteChannel channel) throws IOException {
            Preconditions.checkNotNull((Object)this.getJsonSchema(), (String)"Schema cannot be null");
            Schema schema = new Schema.Parser().parse(this.getJsonSchema());
            BeamParquetOutputFile beamParquetOutputFile = new BeamParquetOutputFile(Channels.newOutputStream(channel));
            AvroParquetWriter.Builder builder = (AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)beamParquetOutputFile).withSchema(schema).withCompressionCodec(this.getCompressionCodec())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE);
            if (this.getConfiguration() != null) {
                builder = (AvroParquetWriter.Builder)builder.withConf(this.getConfiguration().get());
            }
            this.writer = builder.build();
        }

        public void write(GenericRecord element) throws IOException {
            Preconditions.checkNotNull(this.writer, (String)"Writer cannot be null");
            this.writer.write((Object)element);
        }

        public void flush() throws IOException {
            this.writer.close();
        }

        private static class BeamOutputStream
        extends PositionOutputStream {
            private long position = 0L;
            private OutputStream outputStream;

            private BeamOutputStream(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public long getPos() throws IOException {
                return this.position;
            }

            public void write(int b) throws IOException {
                ++this.position;
                this.outputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.outputStream.write(b, off, len);
                this.position += (long)len;
            }

            public void flush() throws IOException {
                this.outputStream.flush();
            }

            public void close() throws IOException {
                this.outputStream.close();
            }
        }

        private static class BeamParquetOutputFile
        implements OutputFile {
            private OutputStream outputStream;

            BeamParquetOutputFile(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public PositionOutputStream create(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public PositionOutputStream createOrOverwrite(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return 0L;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setJsonSchema(String var1);

            abstract Builder setCompressionCodec(CompressionCodecName var1);

            abstract Builder setConfiguration(SerializableConfiguration var1);

            abstract Sink build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<GenericRecord>> {
        @Nullable
        abstract Schema getSchema();

        @Nullable
        abstract GenericData getAvroDataModel();

        @Nullable
        abstract Schema getEncoderSchema();

        @Nullable
        abstract Schema getProjectionSchema();

        abstract boolean isSplittable();

        abstract Builder toBuilder();

        public ReadFiles withAvroDataModel(GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public ReadFiles withProjection(Schema projectionSchema, Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setEncoderSchema(encoderSchema).setSplittable(true).build();
        }

        public ReadFiles withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public PCollection<GenericRecord> expand(PCollection<FileIO.ReadableFile> input) {
            Preconditions.checkNotNull((Object)this.getSchema(), (String)"Schema can not be null");
            if (this.isSplittable()) {
                Schema coderSchema = this.getProjectionSchema() == null ? this.getSchema() : this.getEncoderSchema();
                return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new SplitReadFn(this.getAvroDataModel(), this.getProjectionSchema())))).setCoder((Coder)AvroCoder.of((Schema)coderSchema));
            }
            return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ReadFn(this.getAvroDataModel())))).setCoder((Coder)AvroCoder.of((Schema)this.getSchema()));
        }

        private static class BeamParquetInputFile
        implements InputFile {
            private SeekableByteChannel seekableByteChannel;

            BeamParquetInputFile(SeekableByteChannel seekableByteChannel) {
                this.seekableByteChannel = seekableByteChannel;
            }

            public long getLength() throws IOException {
                return this.seekableByteChannel.size();
            }

            public SeekableInputStream newStream() {
                return new DelegatingSeekableInputStream(Channels.newInputStream(this.seekableByteChannel)){

                    public long getPos() throws IOException {
                        return seekableByteChannel.position();
                    }

                    public void seek(long newPos) throws IOException {
                        seekableByteChannel.position(newPos);
                    }
                };
            }
        }

        static class ReadFn
        extends DoFn<FileIO.ReadableFile, GenericRecord> {
            private Class<? extends GenericData> modelClass;

            ReadFn(GenericData model) {
                this.modelClass = model != null ? model.getClass() : null;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext processContext) throws Exception {
                FileIO.ReadableFile file = (FileIO.ReadableFile)processContext.element();
                if (!file.getMetadata().isReadSeekEfficient()) {
                    ResourceId filename = file.getMetadata().resourceId();
                    throw new RuntimeException(String.format("File has to be seekable: %s", filename));
                }
                SeekableByteChannel seekableByteChannel = file.openSeekable();
                AvroParquetReader.Builder builder = AvroParquetReader.builder((InputFile)new BeamParquetInputFile(seekableByteChannel));
                if (this.modelClass != null) {
                    builder = builder.withDataModel((GenericData)this.modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]));
                }
                try (ParquetReader reader = builder.build();){
                    GenericRecord read;
                    while ((read = (GenericRecord)reader.read()) != null) {
                        processContext.output((Object)read);
                    }
                }
            }
        }

        public static class BlockTracker
        extends OffsetRangeTracker {
            private long totalWork;
            private long progress;
            private long approximateRecordSize;

            public BlockTracker(OffsetRange range, long totalByteSize, long recordCount) {
                super(range);
                if (recordCount != 0L) {
                    this.approximateRecordSize = totalByteSize / recordCount;
                    this.totalWork = this.approximateRecordSize * recordCount;
                    this.progress = 0L;
                }
            }

            public void makeProgress() throws Exception {
                this.progress += this.approximateRecordSize;
                if (this.progress > this.totalWork) {
                    throw new IOException("Making progress out of range");
                }
            }

            public RestrictionTracker.Progress getProgress() {
                return super.getProgress();
            }
        }

        @DoFn.BoundedPerElement
        static class SplitReadFn
        extends DoFn<FileIO.ReadableFile, GenericRecord> {
            private Class<? extends GenericData> modelClass;
            private static final Logger LOG = LoggerFactory.getLogger(SplitReadFn.class);
            private String requestSchemaString;
            private static final long SPLIT_LIMIT = 64000000L;

            SplitReadFn(GenericData model, Schema requestSchema) {
                this.modelClass = model != null ? model.getClass() : null;
                this.requestSchemaString = requestSchema != null ? requestSchema.toString() : null;
            }

            ParquetFileReader getParquetFileReader(FileIO.ReadableFile file) throws Exception {
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)this.getConfWithModelClass()).build();
                return ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element FileIO.ReadableFile file, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<GenericRecord> outputReceiver) throws Exception {
                LOG.debug("start " + ((OffsetRange)tracker.currentRestriction()).getFrom() + " to " + ((OffsetRange)tracker.currentRestriction()).getTo());
                Configuration conf = this.getConfWithModelClass();
                GenericData model = null;
                if (this.modelClass != null) {
                    model = (GenericData)this.modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                }
                AvroReadSupport readSupport = new AvroReadSupport(model);
                if (this.requestSchemaString != null) {
                    AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)new Schema.Parser().parse(this.requestSchemaString));
                }
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)conf).build();
                ParquetFileReader reader = ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);
                FilterCompat.Filter filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)options.getRecordFilter(), (String)"filter");
                Configuration hadoopConf = ((HadoopReadOptions)options).getConf();
                FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
                MessageType fileSchema = parquetFileMetadata.getSchema();
                Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
                ReadSupport.ReadContext readContext = readSupport.init(new InitContext(hadoopConf, Maps.transformValues((Map)fileMetadata, ImmutableSet::of), fileSchema));
                ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
                RecordMaterializer recordConverter = readSupport.prepareForRead(hadoopConf, fileMetadata, fileSchema, readContext);
                reader.setRequestedSchema(readContext.getRequestedSchema());
                MessageColumnIO columnIO = columnIOFactory.getColumnIO(readContext.getRequestedSchema(), fileSchema, true);
                long currentBlock = ((OffsetRange)tracker.currentRestriction()).getFrom();
                int i = 0;
                while ((long)i < currentBlock) {
                    reader.skipNextRowGroup();
                    ++i;
                }
                while (tracker.tryClaim((Object)currentBlock)) {
                    long currentRow;
                    PageReadStore pages = reader.readNextRowGroup();
                    LOG.debug("block {} read in memory. row count = {}", (Object)currentBlock, (Object)pages.getRowCount());
                    ++currentBlock;
                    RecordReader recordReader = columnIO.getRecordReader(pages, recordConverter, options.useRecordFilter() ? filter : FilterCompat.NOOP);
                    long totalRows = pages.getRowCount();
                    for (currentRow = 0L; currentRow < totalRows; ++currentRow) {
                        try {
                            GenericRecord record;
                            try {
                                record = (GenericRecord)recordReader.read();
                            }
                            catch (RecordMaterializer.RecordMaterializationException e) {
                                LOG.warn("skipping a corrupt record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                continue;
                            }
                            if (record == null) {
                                LOG.debug("filtered record reader reached end of block in block {} in file {}", (Object)currentBlock, (Object)file.toString());
                                break;
                            }
                            if (recordReader.shouldSkipCurrentRecord()) {
                                LOG.debug("skipping record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                continue;
                            }
                            outputReceiver.output((Object)record);
                            continue;
                        }
                        catch (RuntimeException e) {
                            throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", currentRow, currentBlock, file.toString()), (Throwable)e);
                        }
                    }
                    LOG.debug("Finish processing {} rows from block {} in file {}", new Object[]{currentRow, currentBlock - 1L, file.toString()});
                }
            }

            public Configuration getConfWithModelClass() throws Exception {
                Configuration conf = new Configuration();
                Object model = null;
                if (this.modelClass != null) {
                    model = (GenericData)this.modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                }
                if (model != null && (model.getClass() == GenericData.class || model.getClass() == SpecificData.class)) {
                    conf.setBoolean("parquet.avro.compatible", true);
                } else {
                    conf.setBoolean("parquet.avro.compatible", false);
                }
                return conf;
            }

            @DoFn.GetInitialRestriction
            public OffsetRange getInitialRestriction(@DoFn.Element FileIO.ReadableFile file) throws Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                return new OffsetRange(0L, (long)reader.getRowGroups().size());
            }

            @DoFn.SplitRestriction
            public void split(@DoFn.Restriction OffsetRange restriction, DoFn.OutputReceiver<OffsetRange> out, @DoFn.Element FileIO.ReadableFile file) throws Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                List rowGroups = reader.getRowGroups();
                for (OffsetRange offsetRange : this.splitBlockWithLimit(restriction.getFrom(), restriction.getTo(), rowGroups, 64000000L)) {
                    out.output((Object)offsetRange);
                }
            }

            public ArrayList<OffsetRange> splitBlockWithLimit(long start, long end, List<BlockMetaData> blockList, long limit) {
                ArrayList<OffsetRange> offsetList = new ArrayList<OffsetRange>();
                long totalSize = 0L;
                long rangeStart = start;
                for (long rangeEnd = start; rangeEnd < end; ++rangeEnd) {
                    if ((totalSize += blockList.get((int)rangeEnd).getTotalByteSize()) < limit) continue;
                    offsetList.add(new OffsetRange(rangeStart, rangeEnd + 1L));
                    rangeStart = rangeEnd + 1L;
                    totalSize = 0L;
                }
                if (totalSize != 0L) {
                    offsetList.add(new OffsetRange(rangeStart, end));
                }
                return offsetList;
            }

            @DoFn.NewTracker
            public RestrictionTracker<OffsetRange, Long> newTracker(@DoFn.Restriction OffsetRange restriction, @DoFn.Element FileIO.ReadableFile file) throws Exception {
                CountAndSize recordCountAndSize = this.getRecordCountAndSize(file, restriction);
                return new BlockTracker(restriction, Math.round(recordCountAndSize.getSize()), Math.round(recordCountAndSize.getCount()));
            }

            @DoFn.GetRestrictionCoder
            public OffsetRange.Coder getRestrictionCoder() {
                return new OffsetRange.Coder();
            }

            @DoFn.GetSize
            public double getSize(@DoFn.Element FileIO.ReadableFile file, @DoFn.Restriction OffsetRange restriction) throws Exception {
                return this.getRecordCountAndSize(file, restriction).getSize();
            }

            private CountAndSize getRecordCountAndSize(FileIO.ReadableFile file, OffsetRange restriction) throws Exception {
                ParquetFileReader reader = this.getParquetFileReader(file);
                double size = 0.0;
                double recordCount = 0.0;
                for (long i = restriction.getFrom(); i < restriction.getTo(); ++i) {
                    BlockMetaData block = (BlockMetaData)reader.getRowGroups().get((int)i);
                    recordCount += (double)block.getRowCount();
                    size += (double)block.getTotalByteSize();
                }
                CountAndSize countAndSize = CountAndSize.create(recordCount, size);
                return countAndSize;
            }

            @AutoValue
            static abstract class CountAndSize {
                CountAndSize() {
                }

                static CountAndSize create(double count, double size) {
                    return new AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize(count, size);
                }

                abstract double getCount();

                abstract double getSize();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSchema(Schema var1);

            abstract Builder setAvroDataModel(GenericData var1);

            abstract Builder setEncoderSchema(Schema var1);

            abstract Builder setProjectionSchema(Schema var1);

            abstract Builder setSplittable(boolean var1);

            abstract ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<GenericRecord>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        @Nullable
        abstract Schema getSchema();

        @Nullable
        abstract Schema getProjectionSchema();

        @Nullable
        abstract Schema getEncoderSchema();

        @Nullable
        abstract GenericData getAvroDataModel();

        abstract boolean isSplittable();

        abstract Builder toBuilder();

        public Read from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read from(String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Read withProjection(Schema projectionSchema, Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setSplittable(true).setEncoderSchema(encoderSchema).build();
        }

        public Read withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public Read withAvroDataModel(GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public PCollection<GenericRecord> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (String)"Filepattern cannot be null.");
            PCollection inputFiles = (PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches());
            if (this.isSplittable()) {
                return (PCollection)inputFiles.apply((PTransform)ParquetIO.readFiles(this.getSchema()).withSplit().withAvroDataModel(this.getAvroDataModel()).withProjection(this.getProjectionSchema(), this.getEncoderSchema()));
            }
            return (PCollection)inputFiles.apply((PTransform)ParquetIO.readFiles(this.getSchema()).withAvroDataModel(this.getAvroDataModel()));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSplittable(boolean var1);

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setSchema(Schema var1);

            abstract Builder setEncoderSchema(Schema var1);

            abstract Builder setProjectionSchema(Schema var1);

            abstract Builder setAvroDataModel(GenericData var1);

            abstract Read build();
        }
    }
}

