/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.KafkaIOUtils;
import org.apache.beam.sdk.io.kafka.KafkaUnboundedReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class KafkaCheckpointMark
implements UnboundedSource.CheckpointMark {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMark> partitions;
    @AvroIgnore
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaUnboundedReader<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> reader;
    private static final @UnknownKeyFor @NonNull @Initialized long OFFSET_DEDUP_PARTITIONS_PER_SPLIT = 1L;

    private KafkaCheckpointMark() {
    }

    public KafkaCheckpointMark(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMark> partitions, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaUnboundedReader<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> reader) {
        this.partitions = partitions;
        this.reader = reader;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMark> getPartitions() {
        return this.partitions;
    }

    public void finalizeCheckpoint() {
        this.reader.ifPresent(r -> r.finalizeCheckpointMarkAsync(this));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "KafkaCheckpointMark{partitions=" + Joiner.on((String)",").join(this.partitions) + '}';
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getOffsetLimit() {
        if (!this.reader.isPresent()) {
            throw new RuntimeException("KafkaCheckpointMark reader is not present while calling getOffsetLimit().");
        }
        if (!this.reader.get().offsetBasedDeduplicationSupported()) {
            throw new RuntimeException("Unexpected getOffsetLimit() called while KafkaUnboundedReader not configured for offset deduplication.");
        }
        Preconditions.checkState(((long)this.partitions.size() == 1L ? 1 : 0) != 0);
        PartitionMark partition = this.partitions.get(0);
        return KafkaIOUtils.OffsetBasedDeduplication.encodeOffset(partition.getNextOffset());
    }

    public static class PartitionMark
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long MIN_WATERMARK_MILLIS = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        private @UnknownKeyFor @NonNull @Initialized String topic;
        private @UnknownKeyFor @NonNull @Initialized int partition;
        private @UnknownKeyFor @NonNull @Initialized long nextOffset;
        private @UnknownKeyFor @NonNull @Initialized long watermarkMillis = MIN_WATERMARK_MILLIS;

        private PartitionMark() {
        }

        public PartitionMark(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partition, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long watermarkMillis) {
            this.topic = topic;
            this.partition = partition;
            this.nextOffset = offset;
            this.watermarkMillis = watermarkMillis;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTopic() {
            return this.topic;
        }

        public @UnknownKeyFor @NonNull @Initialized int getPartition() {
            return this.partition;
        }

        public @UnknownKeyFor @NonNull @Initialized long getNextOffset() {
            return this.nextOffset;
        }

        public @UnknownKeyFor @NonNull @Initialized long getWatermarkMillis() {
            return this.watermarkMillis;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "PartitionMark{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", nextOffset=" + this.nextOffset + ", watermarkMillis=" + this.watermarkMillis + '}';
        }
    }
}

