/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ConsumerSpEL {
    SpelParserConfiguration config = new SpelParserConfiguration(true, true);
    ExpressionParser parser = new SpelExpressionParser(this.config);
    Expression seek2endExpression = this.parser.parseExpression("#consumer.seekToEnd(#tp)");
    Expression assignExpression = this.parser.parseExpression("#consumer.assign(#tp)");

    public void evaluateSeek2End(Consumer consumer, TopicPartition topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", (Object)topicPartitions);
        this.seek2endExpression.getValue((EvaluationContext)mapContext);
    }

    public void evaluateAssign(Consumer consumer, Collection<TopicPartition> topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", topicPartitions);
        this.assignExpression.getValue((EvaluationContext)mapContext);
    }
}

