/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc.providers;

import com.google.auto.service.AutoService;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.io.jdbc.JdbcReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class ReadFromMySqlSchemaTransformProvider
extends JdbcReadSchemaTransformProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReadFromMySqlSchemaTransformProvider.class);

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.MYSQL_READ);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String description() {
        return this.inheritedDescription("MySQL", "ReadFromMySql", "mysql", 3306);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String jdbcType() {
        return "mysql";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration configuration) {
        Integer fetchSize;
        String jdbcType = configuration.getJdbcType();
        if (jdbcType != null && !jdbcType.isEmpty() && !jdbcType.equals(this.jdbcType())) {
            LOG.warn("Wrong JDBC type. Expected '{}' but got '{}'. Overriding with '{}'.", new Object[]{this.jdbcType(), jdbcType, this.jdbcType()});
            configuration = configuration.toBuilder().setJdbcType(this.jdbcType()).build();
        }
        if ((fetchSize = configuration.getFetchSize()) != null && fetchSize > 0 && configuration.getJdbcUrl() != null && !configuration.getJdbcUrl().contains("useCursorFetch=true")) {
            throw new IllegalArgumentException("It is required to set useCursorFetch=true in the JDBC URL when using fetchSize for MySQL");
        }
        return new MySqlReadSchemaTransform(configuration);
    }

    public static class MySqlReadSchemaTransform
    extends JdbcReadSchemaTransformProvider.JdbcReadSchemaTransform {
        public MySqlReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration config) {
            super(config, "mysql");
        }
    }
}

