/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.JdbcWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration
extends JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration {
    private final String jdbcUrl;
    private final Boolean autosharding;
    private final List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql;
    private final String connectionProperties;
    private final String driverClassName;
    private final String driverJars;
    private final Long batchSize;
    private final String jdbcType;
    private final String location;
    private final String password;
    private final String username;
    private final String writeStatement;

    private AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration(String jdbcUrl, @Nullable Boolean autosharding, @Nullable List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql, @Nullable String connectionProperties, @Nullable String driverClassName, @Nullable String driverJars, @Nullable Long batchSize, @Nullable String jdbcType, @Nullable String location, @Nullable String password, @Nullable String username, @Nullable String writeStatement) {
        this.jdbcUrl = jdbcUrl;
        this.autosharding = autosharding;
        this.connectionInitSql = connectionInitSql;
        this.connectionProperties = connectionProperties;
        this.driverClassName = driverClassName;
        this.driverJars = driverJars;
        this.batchSize = batchSize;
        this.jdbcType = jdbcType;
        this.location = location;
        this.password = password;
        this.username = username;
        this.writeStatement = writeStatement;
    }

    @Override
    @SchemaFieldDescription(value="Connection URL for the JDBC sink.")
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="If true, enables using a dynamically determined number of shards to write.")
    public Boolean getAutosharding() {
        return this.autosharding;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Sets the connection init sql statements used by the Driver. Only MySQL and MariaDB support this.")
    public List<@org.checkerframework.checker.nullness.qual.Nullable String> getConnectionInitSql() {
        return this.connectionInitSql;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Used to set connection properties passed to the JDBC driver not already defined as standalone parameter (e.g. username and password can be set using parameters above accordingly). Format of the string must be \"key1=value1;key2=value2;\".")
    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Name of a Java Driver class to use to connect to the JDBC source. For example, \"com.mysql.jdbc.Driver\".")
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Comma separated path(s) for the JDBC driver jar(s). This can be a local path or GCS (gs://) path.")
    public String getDriverJars() {
        return this.driverJars;
    }

    @Override
    @Nullable
    public Long getBatchSize() {
        return this.batchSize;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Type of JDBC source. When specified, an appropriate default Driver will be packaged with the transform. One of mysql, postgres, oracle, or mssql.")
    public String getJdbcType() {
        return this.jdbcType;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Name of the table to write to.")
    public String getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Password for the JDBC source.")
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Username for the JDBC source.")
    public String getUsername() {
        return this.username;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="SQL query used to insert records into the JDBC sink.")
    public String getWriteStatement() {
        return this.writeStatement;
    }

    public String toString() {
        return "JdbcWriteSchemaTransformConfiguration{jdbcUrl=" + this.jdbcUrl + ", autosharding=" + this.autosharding + ", connectionInitSql=" + this.connectionInitSql + ", connectionProperties=" + this.connectionProperties + ", driverClassName=" + this.driverClassName + ", driverJars=" + this.driverJars + ", batchSize=" + this.batchSize + ", jdbcType=" + this.jdbcType + ", location=" + this.location + ", password=" + this.password + ", username=" + this.username + ", writeStatement=" + this.writeStatement + "}";
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration) {
            JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration that = (JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration)o;
            return this.jdbcUrl.equals(that.getJdbcUrl()) && (this.autosharding == null ? that.getAutosharding() == null : this.autosharding.equals(that.getAutosharding())) && (this.connectionInitSql == null ? that.getConnectionInitSql() == null : this.connectionInitSql.equals(that.getConnectionInitSql())) && (this.connectionProperties == null ? that.getConnectionProperties() == null : this.connectionProperties.equals(that.getConnectionProperties())) && (this.driverClassName == null ? that.getDriverClassName() == null : this.driverClassName.equals(that.getDriverClassName())) && (this.driverJars == null ? that.getDriverJars() == null : this.driverJars.equals(that.getDriverJars())) && (this.batchSize == null ? that.getBatchSize() == null : this.batchSize.equals(that.getBatchSize())) && (this.jdbcType == null ? that.getJdbcType() == null : this.jdbcType.equals(that.getJdbcType())) && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.writeStatement == null ? that.getWriteStatement() == null : this.writeStatement.equals(that.getWriteStatement()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jdbcUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.autosharding == null ? 0 : this.autosharding.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectionInitSql == null ? 0 : this.connectionInitSql.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectionProperties == null ? 0 : this.connectionProperties.hashCode();
        h$ *= 1000003;
        h$ ^= this.driverClassName == null ? 0 : this.driverClassName.hashCode();
        h$ *= 1000003;
        h$ ^= this.driverJars == null ? 0 : this.driverJars.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSize == null ? 0 : this.batchSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.jdbcType == null ? 0 : this.jdbcType.hashCode();
        h$ *= 1000003;
        h$ ^= this.location == null ? 0 : this.location.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        return h$ ^= this.writeStatement == null ? 0 : this.writeStatement.hashCode();
    }

    static final class Builder
    extends JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder {
        private String jdbcUrl;
        private Boolean autosharding;
        private List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql;
        private String connectionProperties;
        private String driverClassName;
        private String driverJars;
        private Long batchSize;
        private String jdbcType;
        private String location;
        private String password;
        private String username;
        private String writeStatement;

        Builder() {
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setJdbcUrl(String jdbcUrl) {
            if (jdbcUrl == null) {
                throw new NullPointerException("Null jdbcUrl");
            }
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setAutosharding(Boolean autosharding) {
            this.autosharding = autosharding;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setConnectionInitSql(List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql) {
            this.connectionInitSql = connectionInitSql;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setConnectionProperties(String connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setDriverJars(String driverJars) {
            this.driverJars = driverJars;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setBatchSize(Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setJdbcType(String jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration.Builder setWriteStatement(String writeStatement) {
            this.writeStatement = writeStatement;
            return this;
        }

        @Override
        public JdbcWriteSchemaTransformProvider.JdbcWriteSchemaTransformConfiguration build() {
            if (this.jdbcUrl == null) {
                String missing = " jdbcUrl";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcWriteSchemaTransformProvider_JdbcWriteSchemaTransformConfiguration(this.jdbcUrl, this.autosharding, this.connectionInitSql, this.connectionProperties, this.driverClassName, this.driverJars, this.batchSize, this.jdbcType, this.location, this.password, this.username, this.writeStatement);
        }
    }
}

