/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class JdbcSchemaIOProvider
implements SchemaIOProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "jdbc";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addStringField("driverClassName").addStringField("jdbcUrl").addStringField("username").addStringField("password").addNullableField("connectionProperties", Schema.FieldType.STRING).addNullableField("connectionInitSqls", Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("readQuery", Schema.FieldType.STRING).addNullableField("writeStatement", Schema.FieldType.STRING).addNullableField("fetchSize", Schema.FieldType.INT16).addNullableField("outputParallelization", Schema.FieldType.BOOLEAN).addNullableField("autosharding", Schema.FieldType.BOOLEAN).build();
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @Nullable @UnknownKeyFor @Initialized Schema dataSchema) {
        return new JdbcSchemaIO(location, configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static class JdbcSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Row config;
        protected final @UnknownKeyFor @NonNull @Initialized String location;

        JdbcSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config) {
            this.config = config;
            this.location = location;
        }

        public @Nullable @UnknownKeyFor @Initialized Schema schema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                    Boolean outputParallelization;
                    @Nullable String readQuery = config.getString("readQuery");
                    if (readQuery == null) {
                        readQuery = String.format("SELECT * FROM %s", location);
                    }
                    JdbcIO.ReadRows readRows = JdbcIO.readRows().withDataSourceConfiguration(this.getDataSourceConfiguration()).withQuery(readQuery);
                    @Nullable Short fetchSize = config.getInt16("fetchSize");
                    if (fetchSize != null) {
                        readRows = readRows.withFetchSize(fetchSize.shortValue());
                    }
                    if ((outputParallelization = config.getBoolean("outputParallelization")) != null) {
                        readRows = readRows.withOutputParallelization(outputParallelization);
                    }
                    return (PCollection)input.apply((PTransform)readRows);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    JdbcIO.Write<Row> writeRows = JdbcIO.write().withDataSourceConfiguration(this.getDataSourceConfiguration()).withStatement(this.generateWriteStatement(input.getSchema())).withPreparedStatementSetter(new JdbcUtil.BeamRowPreparedStatementSetter());
                    @Nullable Boolean autosharding = config.getBoolean("autosharding");
                    if (autosharding != null && autosharding.booleanValue()) {
                        writeRows = writeRows.withAutoSharding();
                    }
                    return (PDone)input.apply(writeRows);
                }
            };
        }

        protected @UnknownKeyFor @NonNull @Initialized JdbcIO.DataSourceConfiguration getDataSourceConfiguration() {
            Integer maxConnections;
            Iterable connectionInitSqls;
            JdbcIO.DataSourceConfiguration dataSourceConfiguration = JdbcIO.DataSourceConfiguration.create((String)Preconditions.checkStateNotNull((Object)this.config.getString("driverClassName")), (String)Preconditions.checkStateNotNull((Object)this.config.getString("jdbcUrl"))).withUsername(this.config.getString("username")).withPassword(this.config.getString("password"));
            @Nullable String connectionProperties = this.config.getString("connectionProperties");
            if (connectionProperties != null) {
                dataSourceConfiguration = dataSourceConfiguration.withConnectionProperties(connectionProperties);
            }
            if ((connectionInitSqls = this.config.getIterable("connectionInitSqls")) != null) {
                List<@Nullable String> initSqls = StreamSupport.stream(connectionInitSqls.spliterator(), false).collect(Collectors.toList());
                dataSourceConfiguration = dataSourceConfiguration.withConnectionInitSqls(initSqls);
            }
            if (this.config.getSchema().hasField("maxConnections") && (maxConnections = this.config.getInt32("maxConnections")) != null) {
                dataSourceConfiguration = dataSourceConfiguration.withMaxConnections(maxConnections);
            }
            return dataSourceConfiguration;
        }

        private @UnknownKeyFor @NonNull @Initialized String generateWriteStatement(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            @Nullable String configuredWriteStatement = this.config.getString("writeStatement");
            if (configuredWriteStatement != null) {
                return configuredWriteStatement;
            }
            StringBuilder writeStatement = new StringBuilder("INSERT INTO ");
            writeStatement.append(this.location);
            writeStatement.append(" VALUES(");
            for (int i = 0; i < schema.getFieldCount() - 1; ++i) {
                writeStatement.append("?, ");
            }
            writeStatement.append("?)");
            return writeStatement.toString();
        }
    }
}

