/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import org.apache.beam.sdk.io.hadoop.format.ExternalSynchronization;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormats;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSSynchronization
implements ExternalSynchronization {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HDFSSynchronization.class);
    private static final @UnknownKeyFor @NonNull @Initialized String LOCKS_DIR_PATTERN = "%s/";
    private static final @UnknownKeyFor @NonNull @Initialized String LOCKS_DIR_TASK_PATTERN = "%s/%s";
    private static final @UnknownKeyFor @NonNull @Initialized String LOCKS_DIR_TASK_ATTEMPT_PATTERN = "%s/%s_%s";
    private static final @UnknownKeyFor @NonNull @Initialized String LOCKS_DIR_JOB_FILENAME = "%s/_job";
    private static final transient @UnknownKeyFor @NonNull @Initialized Random RANDOM_GEN = new Random();
    private final @UnknownKeyFor @NonNull @Initialized String locksDir;
    private final @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized Configuration, @UnknownKeyFor @NonNull @Initialized FileSystem, @UnknownKeyFor @NonNull @Initialized IOException> fileSystemFactory;

    public HDFSSynchronization(@UnknownKeyFor @NonNull @Initialized String locksDir) {
        this(locksDir, FileSystem::newInstance);
    }

    HDFSSynchronization(@UnknownKeyFor @NonNull @Initialized String locksDir, @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized Configuration, @UnknownKeyFor @NonNull @Initialized FileSystem, @UnknownKeyFor @NonNull @Initialized IOException> fileSystemFactory) {
        this.locksDir = locksDir;
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tryAcquireJobLock(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        Path path = new Path(this.locksDir, String.format(LOCKS_DIR_JOB_FILENAME, this.getJobJtIdentifier(conf)));
        return this.tryCreateFile(conf, path);
    }

    @Override
    public void releaseJobIdLock(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        Path path = new Path(this.locksDir, String.format(LOCKS_DIR_PATTERN, this.getJobJtIdentifier(conf)));
        try (FileSystem fileSystem = this.fileSystemFactory.apply(conf);){
            if (fileSystem.delete(path, true)) {
                LOG.info("Delete of lock directory {} was successful", (Object)path);
            } else {
                LOG.warn("Delete of lock directory {} was unsuccessful", (Object)path);
            }
        }
        catch (IOException e) {
            String formattedExceptionMessage = String.format("Delete of lock directory %s was unsuccessful", path);
            throw new IllegalStateException(formattedExceptionMessage, e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TaskID acquireTaskIdLock(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        JobID jobId = HadoopFormats.getJobId(conf);
        boolean lockAcquired = false;
        int taskIdCandidate = 0;
        while (!lockAcquired) {
            taskIdCandidate = RANDOM_GEN.nextInt(Integer.MAX_VALUE);
            Path path = new Path(this.locksDir, String.format(LOCKS_DIR_TASK_PATTERN, this.getJobJtIdentifier(conf), taskIdCandidate));
            lockAcquired = this.tryCreateFile(conf, path);
        }
        return HadoopFormats.createTaskID(jobId, taskIdCandidate);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TaskAttemptID acquireTaskAttemptIdLock(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized int taskId) {
        String jobJtIdentifier = this.getJobJtIdentifier(conf);
        JobID jobId = HadoopFormats.getJobId(conf);
        int taskAttemptCandidate = 0;
        boolean taskAttemptAcquired = false;
        while (!taskAttemptAcquired) {
            Path path = new Path(this.locksDir, String.format(LOCKS_DIR_TASK_ATTEMPT_PATTERN, jobJtIdentifier, taskId, ++taskAttemptCandidate));
            taskAttemptAcquired = this.tryCreateFile(conf, path);
        }
        return HadoopFormats.createTaskAttemptID(jobId, taskId, taskAttemptCandidate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @UnknownKeyFor @NonNull @Initialized boolean tryCreateFile(@UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized Path path) {
        try (FileSystem fileSystem = this.fileSystemFactory.apply(conf);){
            boolean bl = fileSystem.createNewFile(path);
            return bl;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Creation of file on path %s failed", path), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String getJobJtIdentifier(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        JobID job = (JobID)Preconditions.checkNotNull((Object)HadoopFormats.getJobId(conf), (String)"Configuration must contain jobID under key %s.", (Object)"mapreduce.job.id");
        return job.getJtIdentifier();
    }

    @FunctionalInterface
    static interface ThrowingFunction<@UnknownKeyFor T1, @UnknownKeyFor T2, @UnknownKeyFor X extends @UnknownKeyFor @NonNull @Initialized Exception>
    extends Serializable {
        public T2 apply(T1 var1) throws X;
    }
}

