/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import com.google.auto.value.AutoValue;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.io.hadoop.format.AutoValue_HadoopFormatIO_Read;
import org.apache.beam.sdk.io.hadoop.format.ExternalSynchronization;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormats;
import org.apache.beam.sdk.io.hadoop.format.IterableCombinerFn;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.AtomicDouble;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFormatIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HadoopFormatIO.class);
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_FORMAT_CLASS_ATTR = "mapreduce.job.outputformat.class";
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_KEY_CLASS = "mapreduce.job.output.key.class";
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_VALUE_CLASS = "mapreduce.job.output.value.class";
    public static final @UnknownKeyFor @NonNull @Initialized String NUM_REDUCES = "mapreduce.job.reduces";
    public static final @UnknownKeyFor @NonNull @Initialized String PARTITIONER_CLASS_ATTR = "mapreduce.job.partitioner.class";
    public static final @UnknownKeyFor @NonNull @Initialized String JOB_ID = "mapreduce.job.id";
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_DIR = "mapreduce.output.fileoutputformat.outputdir";

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Read<K, V> read() {
        return new AutoValue_HadoopFormatIO_Read.Builder().setSkipKeyClone(false).setSkipValueClone(false).build();
    }

    public static <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized Write.WriteBuilder<KeyT, ValueT> write() {
        return new Write.Builder();
    }

    private static class PrepareNonPartitionedTasksFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends DoFn<KV<KeyT, ValueT>, KV<Integer, KV<KeyT, ValueT>>> {
        private transient @UnknownKeyFor @NonNull @Initialized TaskID taskId;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;
        private final @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization;

        private PrepareNonPartitionedTasksFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView, @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization) {
            this.configView = configView;
            this.externalSynchronization = externalSynchronization;
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.taskId = null;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> output, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            if (this.taskId == null) {
                Configuration conf = (Configuration)c.sideInput(this.configView);
                this.taskId = this.externalSynchronization.acquireTaskIdLock(conf);
            }
            output.output((Object)KV.of((Object)this.taskId.getId(), element));
        }
    }

    private static class WriteFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends DoFn<KV<Integer, KV<KeyT, ValueT>>, Integer> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;
        private final @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization;
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Integer>, @UnknownKeyFor @NonNull @Initialized TaskContext<KeyT, ValueT>> bundleTaskContextMap;

        WriteFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView, @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization) {
            this.configView = configView;
            this.externalSynchronization = externalSynchronization;
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.bundleTaskContextMap = new HashMap<KV<BoundedWindow, Integer>, TaskContext<KeyT, ValueT>>();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> element, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow b) {
            Integer taskID = (Integer)element.getKey();
            KV win2TaskId = KV.of((Object)b, (Object)taskID);
            TaskContext taskContext = this.bundleTaskContextMap.computeIfAbsent((KV<BoundedWindow, Integer>)win2TaskId, w2t -> this.setupTask((Integer)w2t.getValue(), c));
            this.write((KV)element.getValue(), taskContext);
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            if (this.bundleTaskContextMap == null) {
                return;
            }
            for (Map.Entry<KV<BoundedWindow, Integer>, TaskContext<KeyT, ValueT>> entry : this.bundleTaskContextMap.entrySet()) {
                TaskContext<KeyT, ValueT> taskContext = entry.getValue();
                try {
                    taskContext.getRecordWriter().close(taskContext.getTaskAttemptContext());
                    taskContext.getOutputCommitter().commitTask(taskContext.getTaskAttemptContext());
                    LOG.info("Write task for {} was successfully committed!", taskContext);
                }
                catch (Exception e) {
                    this.processTaskException(taskContext, e);
                }
                BoundedWindow window = (BoundedWindow)entry.getKey().getKey();
                c.output((Object)taskContext.getTaskId(), Objects.requireNonNull(window).maxTimestamp(), window);
            }
        }

        private void processTaskException(@UnknownKeyFor @NonNull @Initialized TaskContext<KeyT, ValueT> taskContext, @UnknownKeyFor @NonNull @Initialized Exception e) {
            LOG.warn("Write task for {} failed. Will abort task.", taskContext);
            taskContext.abortTask();
            throw new IllegalArgumentException(e);
        }

        private void write(@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> kv, @UnknownKeyFor @NonNull @Initialized TaskContext<KeyT, ValueT> taskContext) {
            try {
                RecordWriter<KeyT, ValueT> recordWriter = taskContext.getRecordWriter();
                recordWriter.write(kv.getKey(), kv.getValue());
            }
            catch (Exception e) {
                this.processTaskException(taskContext, e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized TaskContext<KeyT, ValueT> setupTask(@UnknownKeyFor @NonNull @Initialized Integer taskId, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            Configuration conf = (Configuration)c.sideInput(this.configView);
            TaskAttemptID taskAttemptID = this.externalSynchronization.acquireTaskAttemptIdLock(conf, taskId);
            TaskContext taskContext = new TaskContext(taskAttemptID, conf);
            try {
                taskContext.getOutputCommitter().setupTask(taskContext.getTaskAttemptContext());
            }
            catch (Exception e) {
                this.processTaskException(taskContext, e);
            }
            LOG.info("Task with id {} of job {} was successfully setup!", (Object)taskId, (Object)HadoopFormats.getJobId(conf).getJtIdentifier());
            return taskContext;
        }
    }

    private static class AssignTaskFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends DoFn<KV<KeyT, ValueT>, KV<Integer, KV<KeyT, ValueT>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized TaskID> partitionToTaskContext;
        private transient @UnknownKeyFor @NonNull @Initialized Partitioner<KeyT, ValueT> partitioner;
        private transient @UnknownKeyFor @NonNull @Initialized Integer reducersCount;
        private transient @UnknownKeyFor @NonNull @Initialized JobID jobId;

        AssignTaskFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView) {
            this.configView = configView;
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.partitionToTaskContext = new HashMap<Integer, TaskID>();
            this.partitioner = null;
            this.jobId = null;
            this.reducersCount = null;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> receiver, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Configuration config = (Configuration)c.sideInput(this.configView);
            TaskID taskID = this.createTaskIDForKV(element, config);
            int taskId = taskID.getId();
            receiver.output((Object)KV.of((Object)taskId, element));
        }

        private @UnknownKeyFor @NonNull @Initialized TaskID createTaskIDForKV(@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> kv, @UnknownKeyFor @NonNull @Initialized Configuration config) {
            int taskContextKey = this.getPartitioner(config).getPartition(kv.getKey(), kv.getValue(), this.getReducersCount(config));
            return this.partitionToTaskContext.computeIfAbsent(taskContextKey, key -> HadoopFormats.createTaskID(this.getJobId(config), key));
        }

        private @UnknownKeyFor @NonNull @Initialized JobID getJobId(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            if (this.jobId == null) {
                this.jobId = HadoopFormats.getJobId(config);
            }
            return this.jobId;
        }

        private @UnknownKeyFor @NonNull @Initialized int getReducersCount(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            if (this.reducersCount == null) {
                this.reducersCount = HadoopFormats.getReducersCount(config);
            }
            return this.reducersCount;
        }

        private @UnknownKeyFor @NonNull @Initialized Partitioner<KeyT, ValueT> getPartitioner(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            if (this.partitioner == null) {
                this.partitioner = HadoopFormats.getPartitioner(config);
            }
            return this.partitioner;
        }
    }

    private static class CommitJobFn<@UnknownKeyFor T>
    extends DoFn<Iterable<T>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;
        private final @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization;

        CommitJobFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView, @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization) {
            this.configView = configView;
            this.externalSynchronization = externalSynchronization;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Configuration config = (Configuration)c.sideInput(this.configView);
            this.cleanupJob(config);
        }

        private void cleanupJob(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            this.externalSynchronization.releaseJobIdLock(config);
            JobID jobID = HadoopFormats.getJobId(config);
            TaskAttemptContext cleanupTaskContext = HadoopFormats.createCleanupTaskContext(config, jobID);
            OutputFormat outputFormat = HadoopFormats.createOutputFormatFromConfig(config);
            try {
                OutputCommitter outputCommitter = outputFormat.getOutputCommitter(cleanupTaskContext);
                outputCommitter.commitJob((JobContext)cleanupTaskContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to commit job.", e);
            }
        }
    }

    private static class SetupJobFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends DoFn<KV<KeyT, ValueT>, KV<KeyT, ValueT>> {
        private final @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;
        private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> inputTypeDescriptor;
        private @UnknownKeyFor @NonNull @Initialized boolean isSetupJobAttempted;

        SetupJobFn(@UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> inputTypeDescriptor) {
            this.externalSynchronization = externalSynchronization;
            this.configView = configView;
            this.inputTypeDescriptor = inputTypeDescriptor;
        }

        @DoFn.Setup
        public void setup() {
            this.isSetupJobAttempted = false;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> receiver, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            receiver.output(element);
            if (this.isSetupJobAttempted) {
                return;
            }
            Configuration conf = (Configuration)c.sideInput(this.configView);
            this.validateConfiguration(conf);
            this.validateInputData(conf);
            boolean isJobLockAcquired = this.externalSynchronization.tryAcquireJobLock(conf);
            this.isSetupJobAttempted = true;
            if (!isJobLockAcquired) {
                return;
            }
            try {
                JobID jobId = HadoopFormats.getJobId(conf);
                this.trySetupJob(jobId, conf, window);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private void validateConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
            Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration can not be null");
            Preconditions.checkArgument((conf.get(HadoopFormatIO.OUTPUT_FORMAT_CLASS_ATTR) != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.job.outputformat.class\"");
            Preconditions.checkArgument((conf.get(HadoopFormatIO.OUTPUT_KEY_CLASS) != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.job.output.key.class\"");
            Preconditions.checkArgument((conf.get(HadoopFormatIO.OUTPUT_VALUE_CLASS) != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.job.output.value.class\"");
            Preconditions.checkArgument((conf.get(HadoopFormatIO.JOB_ID) != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.job.id\"");
        }

        private void validateInputData(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
            TypeDescriptor outputFormatKeyClass = TypeDescriptor.of((Class)conf.getClass(HadoopFormatIO.OUTPUT_KEY_CLASS, null));
            TypeDescriptor outputFormatValueClass = TypeDescriptor.of((Class)conf.getClass(HadoopFormatIO.OUTPUT_VALUE_CLASS, null));
            Preconditions.checkArgument((this.inputTypeDescriptor != null ? 1 : 0) != 0, (String)"Input %s must be set!", (Object)TypeDescriptor.class.getSimpleName());
            Preconditions.checkArgument((boolean)KV.class.equals((Object)this.inputTypeDescriptor.getRawType()), (String)"%s expects %s as input type.", (Object)Write.class.getSimpleName(), KV.class);
            Preconditions.checkArgument((boolean)this.inputTypeDescriptor.equals((Object)TypeDescriptors.kvs((TypeDescriptor)outputFormatKeyClass, (TypeDescriptor)outputFormatValueClass)), (String)"%s expects following %ss: KV(Key: %s, Value: %s) but following %ss are set: KV(Key: %s, Value: %s)", (Object[])new Object[]{Write.class.getSimpleName(), TypeDescriptor.class.getSimpleName(), outputFormatKeyClass.getRawType(), outputFormatValueClass.getRawType(), TypeDescriptor.class.getSimpleName(), this.inputTypeDescriptor.resolveType(KV.class.getTypeParameters()[0]), this.inputTypeDescriptor.resolveType(KV.class.getTypeParameters()[1])});
        }

        private void trySetupJob(@UnknownKeyFor @NonNull @Initialized JobID jobId, @UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            try {
                TaskAttemptContext setupTaskContext = HadoopFormats.createSetupTaskContext(conf, jobId);
                OutputFormat jobOutputFormat = HadoopFormats.createOutputFormatFromConfig(conf);
                jobOutputFormat.checkOutputSpecs((JobContext)setupTaskContext);
                jobOutputFormat.getOutputCommitter(setupTaskContext).setupJob((JobContext)setupTaskContext);
                LOG.info("Job with id {} successfully configured from window with max timestamp {}.", (Object)jobId.getJtIdentifier(), (Object)window.maxTimestamp());
            }
            catch (FileAlreadyExistsException e) {
                LOG.info("Job was already set by other worker. Skipping rest of the setup.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to setup job.", e);
            }
        }
    }

    private static class ConfigurationCoder
    extends AtomicCoder<Configuration> {
        private ConfigurationCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Configuration value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outStream);
            value.write((DataOutput)dataOutputStream);
            dataOutputStream.flush();
        }

        public @UnknownKeyFor @NonNull @Initialized Configuration decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            DataInputStream dataInputStream = new DataInputStream(inStream);
            Configuration config = new Configuration(false);
            config.readFields((DataInput)dataInputStream);
            return config;
        }
    }

    private static class TaskContext<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
        private final @UnknownKeyFor @NonNull @Initialized RecordWriter<KeyT, ValueT> recordWriter;
        private final @UnknownKeyFor @NonNull @Initialized OutputCommitter outputCommitter;
        private final @UnknownKeyFor @NonNull @Initialized TaskAttemptContext taskAttemptContext;

        TaskContext(@UnknownKeyFor @NonNull @Initialized TaskAttemptID taskAttempt, @UnknownKeyFor @NonNull @Initialized Configuration conf) {
            this.taskAttemptContext = HadoopFormats.createTaskAttemptContext(conf, taskAttempt);
            OutputFormat outputFormatObj = HadoopFormats.createOutputFormatFromConfig(conf);
            this.outputCommitter = TaskContext.initOutputCommitter(outputFormatObj, conf, this.taskAttemptContext);
            this.recordWriter = this.initRecordWriter(outputFormatObj, this.taskAttemptContext);
        }

        @UnknownKeyFor @NonNull @Initialized RecordWriter<KeyT, ValueT> getRecordWriter() {
            return this.recordWriter;
        }

        @UnknownKeyFor @NonNull @Initialized OutputCommitter getOutputCommitter() {
            return this.outputCommitter;
        }

        @UnknownKeyFor @NonNull @Initialized TaskAttemptContext getTaskAttemptContext() {
            return this.taskAttemptContext;
        }

        @UnknownKeyFor @NonNull @Initialized int getTaskId() {
            return this.taskAttemptContext.getTaskAttemptID().getTaskID().getId();
        }

        @UnknownKeyFor @NonNull @Initialized String getJobId() {
            return this.taskAttemptContext.getJobID().getJtIdentifier();
        }

        void abortTask() {
            try {
                this.outputCommitter.abortTask(this.taskAttemptContext);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to abort task %s of job %s", this.getTaskId(), this.getJobId()));
            }
        }

        private @UnknownKeyFor @NonNull @Initialized RecordWriter<KeyT, ValueT> initRecordWriter(@UnknownKeyFor @NonNull @Initialized OutputFormat<KeyT, ValueT> outputFormatObj, @UnknownKeyFor @NonNull @Initialized TaskAttemptContext taskAttemptContext) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            try {
                LOG.info("Creating new RecordWriter for task {} of Job with id {}.", (Object)taskAttemptContext.getTaskAttemptID().getTaskID().getId(), (Object)taskAttemptContext.getJobID().getJtIdentifier());
                return outputFormatObj.getRecordWriter(taskAttemptContext);
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException("Unable to create RecordWriter object: ", e);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized OutputCommitter initOutputCommitter(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OutputFormat<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputFormatObj, @UnknownKeyFor @NonNull @Initialized Configuration conf, @UnknownKeyFor @NonNull @Initialized TaskAttemptContext taskAttemptContext) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            OutputCommitter outputCommitter;
            try {
                outputCommitter = outputFormatObj.getOutputCommitter(taskAttemptContext);
                if (outputCommitter != null) {
                    outputCommitter.setupJob((JobContext)new JobContextImpl(conf, taskAttemptContext.getJobID()));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create OutputCommitter object: ", e);
            }
            return outputCommitter;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "TaskContext{jobId=" + this.getJobId() + ", taskId=" + this.getTaskId() + ", attemptId=" + this.taskAttemptContext.getTaskAttemptID().getId() + '}';
        }
    }

    public static class Write<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends PTransform<PCollection<KV<KeyT, ValueT>>, PDone> {
        private final transient @Nullable @UnknownKeyFor @Initialized Configuration configuration;
        private final @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration>> configTransform;
        private final @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization;
        private final @UnknownKeyFor @NonNull @Initialized boolean withPartitioning;

        Write(@Nullable @UnknownKeyFor @Initialized Configuration configuration, @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration>> configTransform, @UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization, @UnknownKeyFor @NonNull @Initialized boolean withPartitioning) {
            this.configuration = configuration;
            this.configTransform = configTransform;
            this.externalSynchronization = externalSynchronization;
            this.withPartitioning = withPartitioning;
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Configuration hadoopConfig = this.configuration;
            if (hadoopConfig != null) {
                builder.addIfNotNull(DisplayData.item((String)HadoopFormatIO.OUTPUT_FORMAT_CLASS_ATTR, (String)hadoopConfig.get(HadoopFormatIO.OUTPUT_FORMAT_CLASS_ATTR)).withLabel("OutputFormat Class"));
                builder.addIfNotNull(DisplayData.item((String)HadoopFormatIO.OUTPUT_KEY_CLASS, (String)hadoopConfig.get(HadoopFormatIO.OUTPUT_KEY_CLASS)).withLabel("OutputFormat Key Class"));
                builder.addIfNotNull(DisplayData.item((String)HadoopFormatIO.OUTPUT_VALUE_CLASS, (String)hadoopConfig.get(HadoopFormatIO.OUTPUT_VALUE_CLASS)).withLabel("OutputFormat Value Class"));
                builder.addIfNotNull(DisplayData.item((String)HadoopFormatIO.PARTITIONER_CLASS_ATTR, (String)hadoopConfig.get(HadoopFormatIO.PARTITIONER_CLASS_ATTR, HadoopFormats.DEFAULT_PARTITIONER_CLASS_ATTR.getName())).withLabel("Partitioner Class"));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> input) {
            if (input.isBounded().equals((Object)PCollection.IsBounded.UNBOUNDED) || !input.getWindowingStrategy().equals((Object)WindowingStrategy.globalDefault())) {
                Preconditions.checkArgument((this.configTransform != null ? 1 : 0) != 0, (String)"Writing of unbounded data can be processed only with configuration transformation provider. See %s.withConfigurationTransform()", Write.class);
            }
            this.verifyInputWindowing(input);
            TypeDescriptor<Configuration> configType = new TypeDescriptor<Configuration>(){};
            input.getPipeline().getCoderRegistry().registerCoderForType((TypeDescriptor)configType, (Coder)new ConfigurationCoder());
            PCollectionView<Configuration> configView = this.createConfigurationView(input);
            return this.processJob(input, configView);
        }

        private @UnknownKeyFor @NonNull @Initialized PDone processJob(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView) {
            TypeDescriptor iterableIntType = TypeDescriptors.iterables((TypeDescriptor)TypeDescriptors.integers());
            PCollection validatedInput = (PCollection)input.apply((PTransform)ParDo.of(new SetupJobFn(this.externalSynchronization, configView, input.getTypeDescriptor())).withSideInputs(new PCollectionView[]{configView}));
            PCollection writeData = this.withPartitioning ? (PCollection)validatedInput.apply("GroupDataByPartition", new GroupDataByPartition(configView)) : (PCollection)validatedInput.apply("PrepareNonPartitionedTasks", (PTransform)ParDo.of(new PrepareNonPartitionedTasksFn(configView, this.externalSynchronization)).withSideInputs(new PCollectionView[]{configView}));
            PCollection collectedFinishedWrites = ((PCollection)((PCollection)writeData.apply("Write", (PTransform)ParDo.of(new WriteFn(configView, this.externalSynchronization)).withSideInputs(new PCollectionView[]{configView}))).setTypeDescriptor(TypeDescriptors.integers()).apply("CollectWriteTasks", (PTransform)Combine.globally(new IterableCombinerFn(TypeDescriptors.integers())).withoutDefaults())).setTypeDescriptor(iterableIntType);
            return PDone.in((Pipeline)((PCollection)collectedFinishedWrites.apply("CommitWriteJob", (PTransform)ParDo.of(new CommitJobFn(configView, this.externalSynchronization)).withSideInputs(new PCollectionView[]{configView}))).getPipeline());
        }

        private void verifyInputWindowing(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> input) {
            if (input.isBounded().equals((Object)PCollection.IsBounded.UNBOUNDED)) {
                Preconditions.checkArgument((!input.getWindowingStrategy().equals((Object)WindowingStrategy.globalDefault()) ? 1 : 0) != 0, (String)"Cannot work with %s and GLOBAL %s", (Object)PCollection.IsBounded.UNBOUNDED, (Object)WindowingStrategy.class.getSimpleName());
                Preconditions.checkArgument((boolean)input.getWindowingStrategy().getTrigger().getClass().equals(DefaultTrigger.class), (String)"Cannot work with %s trigger. Write works correctly only with %s", (Object)input.getWindowingStrategy().getTrigger().getClass().getSimpleName(), (Object)DefaultTrigger.class.getSimpleName());
                Preconditions.checkArgument((boolean)input.getWindowingStrategy().getAllowedLateness().equals((Object)Duration.ZERO), (Object)"Write does not allow late data.");
            }
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> createConfigurationView(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> input) {
            PCollectionView config = this.configuration != null ? (PCollectionView)((PCollection)input.getPipeline().apply("CreateOutputConfig", (PTransform)Create.of((Object)this.configuration, (Object[])new Configuration[0]))).apply((PTransform)View.asSingleton().withDefaultValue((Object)this.configuration)) : (PCollectionView)input.apply("TransformDataIntoConfig", this.configTransform);
            return config;
        }

        static class Builder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
        implements WriteBuilder<KeyT, ValueT>,
        PartitionedWriterBuilder<KeyT, ValueT>,
        ExternalSynchronizationBuilder<KeyT, ValueT> {
            private @UnknownKeyFor @NonNull @Initialized Configuration configuration;
            private @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration>> configTransform;
            private @UnknownKeyFor @NonNull @Initialized boolean isWithPartitioning;

            Builder() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PartitionedWriterBuilder<KeyT, ValueT> withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration config) {
                Preconditions.checkNotNull((Object)config, (Object)"Hadoop configuration cannot be null");
                this.configuration = config;
                return this;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withConfigurationTransform(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration>> configTransform) {
                Preconditions.checkNotNull(configTransform, (Object)"Configuration transformation cannot be null");
                this.isWithPartitioning = true;
                this.configTransform = configTransform;
                return this;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withPartitioning() {
                this.isWithPartitioning = true;
                return this;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withoutPartitioning() {
                this.isWithPartitioning = false;
                return this;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Write<KeyT, ValueT> withExternalSynchronization(@UnknownKeyFor @NonNull @Initialized ExternalSynchronization externalSynchronization) {
                Preconditions.checkNotNull((Object)externalSynchronization, (Object)"External synchronization cannot be null");
                return new Write(this.configuration, this.configTransform, externalSynchronization, this.isWithPartitioning);
            }
        }

        public static interface WriteBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
            public @UnknownKeyFor @NonNull @Initialized PartitionedWriterBuilder<KeyT, ValueT> withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration var1);

            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withConfigurationTransform(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration>> var1);
        }

        public static interface ExternalSynchronizationBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
            public @UnknownKeyFor @NonNull @Initialized Write<KeyT, ValueT> withExternalSynchronization(@UnknownKeyFor @NonNull @Initialized ExternalSynchronization var1);
        }

        public static interface PartitionedWriterBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withPartitioning();

            public @UnknownKeyFor @NonNull @Initialized ExternalSynchronizationBuilder<KeyT, ValueT> withoutPartitioning();
        }
    }

    private static class FlattenGroupedTasks<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends DoFn<KV<Integer, Iterable<KV<KeyT, ValueT>>>, KV<Integer, KV<KeyT, ValueT>>> {
        private FlattenGroupedTasks() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> input, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> outputReceiver) {
            Integer key = (Integer)input.getKey();
            for (KV element : Objects.requireNonNull((Iterable)input.getValue(), "Iterable can not be null.")) {
                outputReceiver.output((Object)KV.of((Object)key, (Object)element));
            }
        }
    }

    private static class GroupDataByPartition<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends PTransform<PCollection<KV<KeyT, ValueT>>, PCollection<KV<Integer, KV<KeyT, ValueT>>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView;

        private GroupDataByPartition(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Configuration> configView) {
            this.configView = configView;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("AssignTask", (PTransform)ParDo.of(new AssignTaskFn(this.configView)).withSideInputs(new PCollectionView[]{this.configView}))).setTypeDescriptor(TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.integers(), (TypeDescriptor)input.getTypeDescriptor())).apply("GroupByTaskId", (PTransform)GroupByKey.create())).apply("FlattenGroupedTasks", (PTransform)ParDo.of(new FlattenGroupedTasks()));
        }
    }

    public static class SerializableSplit
    implements Serializable {
        @UnknownKeyFor @NonNull @Initialized InputSplit inputSplit;

        public SerializableSplit() {
        }

        public SerializableSplit(@UnknownKeyFor @NonNull @Initialized InputSplit split) {
            Preconditions.checkArgument((boolean)(split instanceof Writable), (Object)String.format("Split is not of type Writable: %s", split));
            this.inputSplit = split;
        }

        public @UnknownKeyFor @NonNull @Initialized InputSplit getSplit() {
            return this.inputSplit;
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ObjectWritable ow = new ObjectWritable();
            ow.setConf(new Configuration(false));
            ow.readFields((DataInput)in);
            this.inputSplit = (InputSplit)ow.get();
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            new ObjectWritable((Object)this.inputSplit).write((DataOutput)out);
        }
    }

    public static class HadoopInputFormatBoundedSource<@UnknownKeyFor K, @UnknownKeyFor V>
    extends BoundedSource<KV<K, V>>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SerializableConfiguration conf;
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> keyTranslationFunction;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> valueTranslationFunction;
        private final @UnknownKeyFor @NonNull @Initialized SerializableSplit inputSplit;
        private final @UnknownKeyFor @NonNull @Initialized boolean skipKeyClone;
        private final @UnknownKeyFor @NonNull @Initialized boolean skipValueClone;
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableSplit> inputSplits;
        private @UnknownKeyFor @NonNull @Initialized long boundedSourceEstimatedSize = 0L;
        private transient /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized InputFormat<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputFormatObj;
        private transient @UnknownKeyFor @NonNull @Initialized TaskAttemptContext taskAttemptContext;
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> immutableTypes = new HashSet<Class>(Arrays.asList(String.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, BigInteger.class, BigDecimal.class));

        HadoopInputFormatBoundedSource(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration conf, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> keyTranslationFunction, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> valueTranslationFunction, @UnknownKeyFor @NonNull @Initialized boolean skipKeyClone, @UnknownKeyFor @NonNull @Initialized boolean skipValueClone) {
            this(conf, keyCoder, valueCoder, keyTranslationFunction, valueTranslationFunction, null, skipKeyClone, skipValueClone);
        }

        protected HadoopInputFormatBoundedSource(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration conf, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> keyTranslationFunction, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> valueTranslationFunction, @UnknownKeyFor @NonNull @Initialized SerializableSplit inputSplit, @UnknownKeyFor @NonNull @Initialized boolean skipKeyClone, @UnknownKeyFor @NonNull @Initialized boolean skipValueClone) {
            this.conf = conf;
            this.inputSplit = inputSplit;
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
            this.keyTranslationFunction = keyTranslationFunction;
            this.valueTranslationFunction = valueTranslationFunction;
            this.skipKeyClone = skipKeyClone;
            this.skipValueClone = skipValueClone;
        }

        public @UnknownKeyFor @NonNull @Initialized SerializableConfiguration getConfiguration() {
            return this.conf;
        }

        public void validate() {
            Preconditions.checkArgument((this.conf != null ? 1 : 0) != 0, (Object)"conf can not be null");
            Preconditions.checkArgument((this.keyCoder != null ? 1 : 0) != 0, (Object)"keyCoder can not be null");
            Preconditions.checkArgument((this.valueCoder != null ? 1 : 0) != 0, (Object)"valueCoder can not be null");
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Configuration hadoopConfig = this.getConfiguration().get();
            if (hadoopConfig != null) {
                builder.addIfNotNull(DisplayData.item((String)"mapreduce.job.inputformat.class", (String)hadoopConfig.get("mapreduce.job.inputformat.class")).withLabel("InputFormat Class"));
                builder.addIfNotNull(DisplayData.item((String)"mapreduce.input.fileinputformat.inputdir", (String)StringUtils.abbreviate((String)hadoopConfig.get("mapreduce.input.fileinputformat.inputdir"), (int)250)).withLabel("Input Directory"));
                builder.addIfNotNull(DisplayData.item((String)"key.class", (String)hadoopConfig.get("key.class")).withLabel("Key Class"));
                builder.addIfNotNull(DisplayData.item((String)"value.class", (String)hadoopConfig.get("value.class")).withLabel("Value Class"));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.inputSplit != null) {
                LOG.info("Not splitting source {} because source is already split.", (Object)this);
                return ImmutableList.of((Object)this);
            }
            this.computeSplitsIfNecessary();
            LOG.info("Generated {} splits. Size of first split is {} ", (Object)this.inputSplits.size(), (Object)this.inputSplits.get(0).getSplit().getLength());
            return this.inputSplits.stream().map(serializableInputSplit -> new HadoopInputFormatBoundedSource<K, V>(this.conf, this.keyCoder, this.valueCoder, this.keyTranslationFunction, this.valueTranslationFunction, (SerializableSplit)serializableInputSplit, this.skipKeyClone, this.skipValueClone)).collect(Collectors.toList());
        }

        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions po) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.inputSplit == null) {
                this.computeSplitsIfNecessary();
                return this.boundedSourceEstimatedSize;
            }
            return this.inputSplit.getSplit().getLength();
        }

        @VisibleForTesting
        void computeSplitsIfNecessary() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            if (this.inputSplits != null) {
                return;
            }
            this.createInputFormatInstance();
            List splits = this.inputFormatObj.getSplits((JobContext)Job.getInstance((Configuration)this.conf.get()));
            if (splits == null) {
                throw new IOException("Error in computing splits, getSplits() returns null.");
            }
            if (splits.isEmpty()) {
                throw new IOException("Error in computing splits, getSplits() returns a empty list");
            }
            this.boundedSourceEstimatedSize = 0L;
            this.inputSplits = new ArrayList<SerializableSplit>();
            for (InputSplit inputSplit : splits) {
                if (inputSplit == null) {
                    throw new IOException("Error in computing splits, split is null in InputSplits list populated by getSplits() : ");
                }
                this.boundedSourceEstimatedSize += inputSplit.getLength();
                this.inputSplits.add(new SerializableSplit(inputSplit));
            }
        }

        protected void createInputFormatInstance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.inputFormatObj == null) {
                try {
                    this.taskAttemptContext = new TaskAttemptContextImpl(this.conf.get(), new TaskAttemptID());
                    this.inputFormatObj = (InputFormat)this.conf.get().getClassByName(this.conf.get().get("mapreduce.job.inputformat.class")).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (Configurable.class.isAssignableFrom(this.inputFormatObj.getClass())) {
                        ((Configurable)this.inputFormatObj).setConf(this.conf.get());
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IOException("Unable to create InputFormat object: ", e);
                }
            }
        }

        @VisibleForTesting
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized InputFormat<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getInputFormat() {
            return this.inputFormatObj;
        }

        @VisibleForTesting
        void setInputFormatObj(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized InputFormat<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputFormatObj) {
            this.inputFormatObj = inputFormatObj;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> getOutputCoder() {
            return KvCoder.of(this.keyCoder, this.valueCoder);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized KV<K, V>> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.validate();
            if (this.inputSplit == null) {
                throw new IOException("Cannot create reader as source is not split yet.");
            }
            this.createInputFormatInstance();
            return new HadoopInputFormatReader(this, this.keyTranslationFunction, this.valueTranslationFunction, this.inputSplit, this.inputFormatObj, this.taskAttemptContext);
        }

        class HadoopInputFormatReader<@UnknownKeyFor T1, @UnknownKeyFor T2>
        extends BoundedSource.BoundedReader<KV<K, V>> {
            private final @UnknownKeyFor @NonNull @Initialized HadoopInputFormatBoundedSource<K, V> source;
            private final @Nullable @UnknownKeyFor @Initialized SimpleFunction<T1, K> keyTranslationFunction;
            private final @Nullable @UnknownKeyFor @Initialized SimpleFunction<T2, V> valueTranslationFunction;
            private final @UnknownKeyFor @NonNull @Initialized SerializableSplit split;
            private @UnknownKeyFor @NonNull @Initialized RecordReader<T1, T2> recordReader;
            private volatile @UnknownKeyFor @NonNull @Initialized boolean doneReading = false;
            private final @UnknownKeyFor @NonNull @Initialized AtomicLong recordsReturned = new AtomicLong();
            private final @UnknownKeyFor @NonNull @Initialized AtomicDouble progressValue = new AtomicDouble();
            private final transient @UnknownKeyFor @NonNull @Initialized InputFormat<T1, T2> inputFormatObj;
            private final transient @UnknownKeyFor @NonNull @Initialized TaskAttemptContext taskAttemptContext;

            private HadoopInputFormatReader(@Nullable @UnknownKeyFor @Initialized HadoopInputFormatBoundedSource<K, V> source, @Nullable @UnknownKeyFor @Initialized SimpleFunction keyTranslationFunction, @UnknownKeyFor @NonNull @Initialized SimpleFunction valueTranslationFunction, @UnknownKeyFor @NonNull @Initialized SerializableSplit split, @UnknownKeyFor @NonNull @Initialized InputFormat inputFormatObj, TaskAttemptContext taskAttemptContext) {
                this.source = source;
                this.keyTranslationFunction = keyTranslationFunction;
                this.valueTranslationFunction = valueTranslationFunction;
                this.split = split;
                this.inputFormatObj = inputFormatObj;
                this.taskAttemptContext = taskAttemptContext;
            }

            public @UnknownKeyFor @NonNull @Initialized HadoopInputFormatBoundedSource<K, V> getCurrentSource() {
                return this.source;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
                try {
                    this.recordsReturned.set(0L);
                    this.recordReader = this.inputFormatObj.createRecordReader(this.split.getSplit(), this.taskAttemptContext);
                    if (this.recordReader != null) {
                        this.recordReader.initialize(this.split.getSplit(), this.taskAttemptContext);
                        this.progressValue.set(this.getProgress().doubleValue());
                        if (this.recordReader.nextKeyValue()) {
                            this.recordsReturned.incrementAndGet();
                            this.doneReading = false;
                            return true;
                        }
                    } else {
                        throw new IOException(String.format("Null RecordReader object returned by %s", this.inputFormatObj.getClass()));
                    }
                    this.recordReader = null;
                }
                catch (InterruptedException e) {
                    throw new IOException("Could not read because the thread got interrupted while reading the records with an exception: ", e);
                }
                this.doneReading = true;
                return false;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                try {
                    this.progressValue.set(this.getProgress().doubleValue());
                    if (this.recordReader.nextKeyValue()) {
                        this.recordsReturned.incrementAndGet();
                        return true;
                    }
                    this.doneReading = true;
                }
                catch (InterruptedException e) {
                    throw new IOException("Unable to read data: ", e);
                }
                return false;
            }

            public @UnknownKeyFor @NonNull @Initialized KV<K, V> getCurrent() {
                Object value;
                Object key;
                try {
                    key = this.transformKeyOrValue(this.recordReader.getCurrentKey(), this.keyTranslationFunction, HadoopInputFormatBoundedSource.this.keyCoder, HadoopInputFormatBoundedSource.this.skipKeyClone);
                    value = this.transformKeyOrValue(this.recordReader.getCurrentValue(), this.valueTranslationFunction, HadoopInputFormatBoundedSource.this.valueCoder, HadoopInputFormatBoundedSource.this.skipValueClone);
                }
                catch (IOException | InterruptedException e) {
                    LOG.error("Unable to read data: ", (Throwable)e);
                    throw new IllegalStateException("Unable to read data: {}", e);
                }
                return KV.of(key, value);
            }

            private <T, T3> T3 transformKeyOrValue(T input, @Nullable @UnknownKeyFor @Initialized SimpleFunction<T, T3> simpleFunction, @UnknownKeyFor @NonNull @Initialized Coder<T3> coder, @UnknownKeyFor @NonNull @Initialized boolean skipClone) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized ClassCastException {
                Object output = null != simpleFunction ? simpleFunction.apply(input) : input;
                return (T3)(skipClone || output == null ? output : this.cloneIfPossiblyMutable(output, coder));
            }

            private <T> T cloneIfPossiblyMutable(T input, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized ClassCastException {
                if (!this.isKnownImmutable(input)) {
                    input = CoderUtils.clone(coder, input);
                }
                return input;
            }

            private @UnknownKeyFor @NonNull @Initialized boolean isKnownImmutable(@UnknownKeyFor @NonNull @Initialized Object o) {
                return immutableTypes.contains(o.getClass());
            }

            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                LOG.info("Closing reader after reading {} records.", (Object)this.recordsReturned);
                if (this.recordReader != null) {
                    this.recordReader.close();
                    this.recordReader = null;
                }
            }

            public @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
                if (this.doneReading) {
                    return 1.0;
                }
                if (this.recordReader == null || this.recordsReturned.get() == 0L) {
                    return 0.0;
                }
                if (this.progressValue.get() == 0.0) {
                    return null;
                }
                return this.progressValue.doubleValue();
            }

            private @UnknownKeyFor @NonNull @Initialized Double getProgress() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                try {
                    float progress = this.recordReader.getProgress();
                    return (double)progress < 0.0 || progress > 1.0f ? 0.0 : (double)progress;
                }
                catch (IOException e) {
                    LOG.error("Error in computing the fractions consumed as RecordReader.getProgress() throws an exception : ", (Throwable)e);
                    throw new IOException("Error in computing the fractions consumed as RecordReader.getProgress() throws an exception : " + e.getMessage(), e);
                }
            }

            public final @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
                if (this.doneReading) {
                    return 0L;
                }
                return 1L;
            }
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PBegin, PCollection<KV<K, V>>> {
        public abstract @Nullable @UnknownKeyFor @Initialized SerializableConfiguration getConfiguration();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> getKeyTranslationFunction();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> getValueTranslationFunction();

        public abstract @Nullable @UnknownKeyFor @Initialized TypeDescriptor<K> getKeyTypeDescriptor();

        public abstract @Nullable @UnknownKeyFor @Initialized Coder<K> getKeyCoder();

        public abstract @Nullable @UnknownKeyFor @Initialized TypeDescriptor<V> getValueTypeDescriptor();

        public abstract @Nullable @UnknownKeyFor @Initialized Coder<V> getValueCoder();

        public abstract @Nullable @UnknownKeyFor @Initialized Boolean getSkipKeyClone();

        public abstract @Nullable @UnknownKeyFor @Initialized Boolean getSkipValueClone();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getinputFormatClass();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getinputFormatKeyClass();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getinputFormatValueClass();

        public abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            this.validateConfiguration(configuration);
            TypeDescriptor inputFormatClass = TypeDescriptor.of((Class)configuration.getClass("mapreduce.job.inputformat.class", null));
            TypeDescriptor inputFormatKeyClass = TypeDescriptor.of((Class)configuration.getClass("key.class", null));
            TypeDescriptor inputFormatValueClass = TypeDescriptor.of((Class)configuration.getClass("value.class", null));
            Builder<K, V> builder = this.toBuilder().setConfiguration(new SerializableConfiguration(configuration));
            builder.setInputFormatClass(inputFormatClass);
            builder.setInputFormatKeyClass(inputFormatKeyClass);
            builder.setInputFormatValueClass(inputFormatValueClass);
            if (this.getKeyTranslationFunction() == null) {
                builder.setKeyTypeDescriptor(inputFormatKeyClass);
            }
            if (this.getValueTranslationFunction() == null) {
                builder.setValueTypeDescriptor(inputFormatValueClass);
            }
            return builder.build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withKeyTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> function) {
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function can not be null");
            return this.toBuilder().setKeyTranslationFunction(function).setKeyTypeDescriptor(function.getOutputTypeDescriptor()).setKeyCoder(null).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withKeyTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> function, @UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function can not be null");
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.withKeyTranslation(function).toBuilder().setKeyCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withValueTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> function) {
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function can not be null");
            return this.toBuilder().setValueTranslationFunction(function).setValueTypeDescriptor(function.getOutputTypeDescriptor()).setValueCoder(null).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withValueTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> function, @UnknownKeyFor @NonNull @Initialized Coder<V> coder) {
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function can not be null");
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.withValueTranslation(function).toBuilder().setValueCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withSkipKeyClone(@UnknownKeyFor @NonNull @Initialized boolean value) {
            return this.toBuilder().setSkipKeyClone(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<K, V> withSkipValueClone(@UnknownKeyFor @NonNull @Initialized boolean value) {
            return this.toBuilder().setSkipValueClone(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Object valueCoder;
            this.validateTransform();
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            Object keyCoder = this.getKeyCoder();
            if (keyCoder == null) {
                keyCoder = this.getDefaultCoder(this.getKeyTypeDescriptor(), coderRegistry);
            }
            if ((valueCoder = this.getValueCoder()) == null) {
                valueCoder = this.getDefaultCoder(this.getValueTypeDescriptor(), coderRegistry);
            }
            HadoopInputFormatBoundedSource<K, V> source = new HadoopInputFormatBoundedSource<K, V>(this.getConfiguration(), keyCoder, valueCoder, this.getKeyTranslationFunction(), this.getValueTranslationFunction(), this.getSkipKeyClone(), this.getSkipValueClone());
            return (PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from(source));
        }

        private void validateConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"configuration can not be null");
            Preconditions.checkArgument((configuration.get("mapreduce.job.inputformat.class") != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.job.inputformat.class\"");
            Preconditions.checkArgument((configuration.get("key.class") != null ? 1 : 0) != 0, (Object)"configuration must contain \"key.class\"");
            Preconditions.checkArgument((configuration.get("value.class") != null ? 1 : 0) != 0, (Object)"configuration must contain \"value.class\"");
            if (configuration.get("mapreduce.job.inputformat.class").endsWith("DBInputFormat")) {
                Preconditions.checkArgument((configuration.get("mapreduce.jdbc.input.orderby") != null ? 1 : 0) != 0, (Object)"Configuration must contain \"mapreduce.jdbc.input.orderby\" when using DBInputFormat");
            }
        }

        public void validateTransform() {
            Preconditions.checkArgument((this.getConfiguration() != null ? 1 : 0) != 0, (Object)"withConfiguration() is required");
            this.validateTranslationFunction(this.getinputFormatKeyClass(), this.getKeyTranslationFunction(), "Key translation's input type is not same as hadoop InputFormat : %s key class : %s");
            this.validateTranslationFunction(this.getinputFormatValueClass(), this.getValueTranslationFunction(), "Value translation's input type is not same as hadoop InputFormat :  %s value class : %s");
        }

        private void validateTranslationFunction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputType, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> simpleFunction, @UnknownKeyFor @NonNull @Initialized String errorMsg) {
            if (simpleFunction != null && !simpleFunction.getInputTypeDescriptor().equals(inputType)) {
                throw new IllegalArgumentException(String.format(errorMsg, this.getinputFormatClass().getRawType(), inputType.getRawType()));
            }
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getDefaultCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDesc, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
            Class classType = typeDesc.getRawType();
            try {
                return coderRegistry.getCoder(typeDesc);
            }
            catch (CannotProvideCoderException e) {
                if (Writable.class.isAssignableFrom(classType)) {
                    return WritableCoder.of((Class)classType);
                }
                throw new IllegalStateException(String.format("Cannot find coder for %s  : ", typeDesc) + e.getMessage(), e);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor K, @UnknownKeyFor V> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setConfiguration(@UnknownKeyFor @NonNull @Initialized SerializableConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setKeyTranslationFunction(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setValueTranslationFunction(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setKeyTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<K> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setValueTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<V> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setSkipKeyClone(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setSkipValueClone(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setInputFormatClass(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setInputFormatKeyClass(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setInputFormatValueClass(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<K, V> build();
        }
    }
}

